package com.framsticks.framclipse.editors.folding;

import java.util.List;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

import com.framsticks.framclipse.internal.parser.ASTCodeSection;
import com.framsticks.framclipse.internal.parser.ASTFunction;
import com.framsticks.framclipse.internal.parser.ASTProperty;
import com.framsticks.framclipse.internal.parser.ElementWithOffset;


public class FramclipseFoldingAnnotation extends ProjectionAnnotation 
{
	ElementWithOffset annotatedElement;
	
	public FramclipseFoldingAnnotation(ElementWithOffset element)
	{
		this.annotatedElement = element;
	}
	
	public ElementWithOffset getAnnotatedElement()
	{
		return annotatedElement;
	}
	
	public int getAnnotationLength()
	{
		int defaultLen = annotatedElement.getEndOffset() - annotatedElement.getBeginOffset() + 1;
		
		int lineSepLen = System.getProperty("line.separator").length();
		
		if(annotatedElement instanceof ASTFunction)
			return defaultLen + lineSepLen;
		
		if(annotatedElement instanceof ASTProperty)
			return defaultLen + lineSepLen;
		
		if(annotatedElement instanceof ASTCodeSection)
			return defaultLen + lineSepLen;
		
		return defaultLen;
	}
	
	public boolean isEquivalent(FramclipseFoldingAnnotation annot, IDocument doc)
	{
		return annotatedElement.isEquivalent(annot.annotatedElement, doc);
			
	}
	
	public FramclipseFoldingAnnotation hasEquivalent(List<FramclipseFoldingAnnotation> list, IDocument doc)
	{
		for(FramclipseFoldingAnnotation annot : list)
			if(annot.isEquivalent(this, doc))
				return annot;
		
		return null;
	}
}
