package com.framsticks.framclipse.editors.configuration;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class FramscriptPartitionScanner extends RuleBasedPartitionScanner {
	public final static String CODE = "__framscript_code";
	public final static String DESCRIPTION = "__framscript_description";
	public final static String UNDEFINED = "__framscript_undefined";
	
	public final static String COMMENT = "__framscript_comment";

	public final static String[] PARTITION_TYPES = new String[] { CODE, DESCRIPTION, UNDEFINED, COMMENT};

	public FramscriptPartitionScanner(String codeFileName) {
		IToken code = new Token(CODE);
		IToken description = new Token(DESCRIPTION);
		IToken comment = new Token(COMMENT);

		List<IPredicateRule> rules = new ArrayList<IPredicateRule>();
		rules.add(new MultiLineRule(codeFileName + ":~", "~", code, '\\', false));
		rules.add(new MultiLineRule(":~", "~", description, '\\', false));
		rules.add(new EndOfLineRule(":", new Token(UNDEFINED)));
		rules.add(new EndOfLineRule("#", comment));

		IPredicateRule[] result = new IPredicateRule[rules.size()];
		result = rules.toArray(result);
		setPredicateRules(result);
		setDefaultReturnToken(new Token(UNDEFINED));
	}
}
