package com.framsticks.framclipse;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.BundleContext;

import com.framsticks.framclipse.editors.configuration.FramscriptPartitionScanner;
import com.framsticks.framclipse.syntaxColoring.ColorManager;
import com.framsticks.framclipse.syntaxColoring.FramscriptCodeScanner;


/**
 * The activator class controls the plug-in life cycle
 */
public class Framclipse extends AbstractUIPlugin {

	private static final String FRAMSCRIPT_SYNTAX = "framscript.xml";
	private static final String FRAMSCRIPT_CONTEXT = "framscontext.xml";

	public final static String FRAMSCRIPT_PARTITIONING = "__framscript_partitioning";

	// The plug-in ID
	public static final String PLUGIN_ID = "Framclipse";

	// The shared instance
	private static Framclipse plugin;

	private ColorManager colorManager;

	private RuleBasedScanner codeScanner;

	private Map<String, FramscriptPartitionScanner> partitionScanners;

	private Document framscriptSyntax;
	private Document framscriptContext;

	/**
	 * The constructor
	 */
	public Framclipse() {
		plugin = this;
		partitionScanners = new HashMap<String, FramscriptPartitionScanner>();
	}

	/**
	 * Returns the singleton color manager.
	 * 
	 * @return the singleton color manager.
	 */
	public ColorManager getColorManager() {
		if (colorManager == null) {
			colorManager = new ColorManager();
		}
		return colorManager;
	}

	/**
	 * Returns the singleton Framscript scanner.
	 * 
	 * @return the singleton Framscript scanner
	 */
	public RuleBasedScanner getFramscriptCodeScanner() {
		if (codeScanner == null) {
			codeScanner = new FramscriptCodeScanner();
		}
		return codeScanner;
	}

	/**
	 * Return a scanner for creating framscript partitions.
	 * 
	 * @return a scanner for creating framscript partitions
	 */
	public FramscriptPartitionScanner getFramscriptPartitionScanner(String codeFileName) {
		FramscriptPartitionScanner partitionScanner = partitionScanners.get(codeFileName);
		if (partitionScanner == null) {
			partitionScanner = new FramscriptPartitionScanner(codeFileName);
			partitionScanners.put(codeFileName, partitionScanner);
		}
		return partitionScanner;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static Framclipse getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public Document getFramscriptSyntax() {
		if (framscriptSyntax == null) {
			framscriptSyntax = readDocument(FRAMSCRIPT_SYNTAX);
		}

		return framscriptSyntax;
	}

	public Document getFramscriptContext() {
		if (framscriptContext == null) {
			framscriptContext = readDocument(FRAMSCRIPT_CONTEXT);
		}

		return framscriptContext;
	}

	private Document readDocument(String fileName) {
		Document document = null;
		try {
			SAXBuilder builder = new SAXBuilder();
			ClassLoader classLoader = getDefault().getClass().getClassLoader();
			URL syntaxURL = classLoader.getResource(fileName);
			document = builder.build(syntaxURL);
		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return document;
	}
}
