/*
 *  f4_orientmat.cpp - Extension of Orient with matrix multiplication.
 *
 *  f4genotype - f4 format genotype conversions for FramSticks
 *
 *  Copyright (C) 1999,2000  Adam Rotaru-Varga (adam_rotaru@yahoo.com)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "f4_orientmat.h"
#include <math.h>


f4_OrientMat::f4_OrientMat(XYZplanes plane, float angle) 
{
  switch(plane) 
  {
   case xOy:
    x.x = cos(angle); x.y = -sin(angle); x.z = 0.0;
    y.x = sin(angle); y.y =  cos(angle); y.z = 0.0;
    z.x = 0.0;        z.y = 0.0;         z.z = 1.0;
    break;
   case xOz:
    x.x = cos(angle); x.y = 0.0; x.z = -sin(angle);
    y.x = 0.0;        y.y = 1.0; y.z = 0.0;
    z.x = sin(angle); z.y = 0.0; z.z = cos(angle);
    break;
   case yOz:
    x.x = 1.0;  x.y = 0.0;        x.z = 0.0;
    y.x = 0.0;  y.y = cos(angle); y.z = -sin(angle);
    z.x = 0.0;  z.y = sin(angle); z.z =  cos(angle);
    break;
  }
} 


// M3 = this * M2;
f4_OrientMat f4_OrientMat::operator*(const Orient & M2)
{
  f4_OrientMat M3;
  M3.x.x = x.x * M2.x.x + x.y * M2.y.x + x.z * M2.z.x;
  M3.x.y = x.x * M2.x.y + x.y * M2.y.y + x.z * M2.z.y;
  M3.x.z = x.x * M2.x.z + x.y * M2.y.z + x.z * M2.z.z;
  M3.y.x = y.x * M2.x.x + y.y * M2.y.x + y.z * M2.z.x;
  M3.y.y = y.x * M2.x.y + y.y * M2.y.y + y.z * M2.z.y;
  M3.y.z = y.x * M2.x.z + y.y * M2.y.z + y.z * M2.z.z;
  M3.z.x = z.x * M2.x.x + z.y * M2.y.x + z.z * M2.z.x;
  M3.z.y = z.x * M2.x.y + z.y * M2.y.y + z.z * M2.z.y;
  M3.z.z = z.x * M2.x.z + z.y * M2.y.z + z.z * M2.z.z;
  return M3;
}
