%{
// This file is a part of the Framsticks GDK.
// Copyright (C) 2002-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include "framscript-defs.h"
#include "framscript.tab.cpp.h"
#include <math.h>

#define YY_INPUT(buf,result,maxsize) {result=trctx.in->Vread(buf,1,maxsize);}
#define YY_NEVER_INTERACTIVE 1

%}

%option noyywrap
%x asmcode
%x asmcode2
%x comment

%%

\$[0-9a-fA-F]+ {int i; sscanf(yytext+1,"%x",&i); framscriptlval.setInt(i); return CONSTANT;}
0x[0-9a-fA-F]+ {int i; sscanf(yytext+2,"%x",&i); framscriptlval.setInt(i); return CONSTANT;}
[0-9]+\.[0-9]*    {framscriptlval.setDouble(atof(yytext)); return CONSTANT;}
[0-9]+            {framscriptlval.setInt(atoi(yytext)); return CONSTANT;}
[0-9]+\.[0-9]*[eE][+-]?[0-9]+    {framscriptlval.setDouble(atof(yytext)); return CONSTANT;}
[0-9]+*[eE][+-]?[0-9]+           {framscriptlval.setDouble(atof(yytext)); return CONSTANT;}
"null"            {framscriptlval.setEmpty(); return CONSTANT;}
\"([^\\\"]|\\.)*\" {framscriptlval.setString(SString(yytext+1,yyleng-2));return CONSTANT;}
"@line "[0-9]+\n   {trctx.line=atol(yytext+6);}
"@file "[^\n\t\r]+\n {trctx.srcname=SString(yytext+6,yyleng-7);}

[a-zA-Z_][a-zA-Z0-9_]* { int t=lookupToken(yytext);
                         if (t>=0) return t;
                         else
                            {
                            framscriptlval.setString(yytext);
                            return framscriptIsObjectName(yytext)?OBJNAME:IDENT;
                            }
                       }
"=="               return EQUAL;
"<>"               return NOT_EQUAL;
"!="               return NOT_EQUAL;
">="               return GEQUAL;
"<="               return LEQUAL;

"+="                return ASSIGN_ADD;
"-="                return ASSIGN_SUB;
"*="                return ASSIGN_MUL;
"/="                return ASSIGN_DIV;
"%="                return ASSIGN_MOD;

"++"                return PLUSPLUS;
"--"                return MINUSMINUS;

"&&"                return LOGIC_AND;
"||"                return LOGIC_OR;

"<<"                return LSHIFT;
">>"                return RSHIFT;

<INITIAL,asmcode,asmcode2>\/\/.*\n         {trctx.line++;} // komentarz jednoliniowy
<INITIAL,asmcode,asmcode2>\/\/[^\n]*       ;               // komentarz ale nie ma potem \n

<INITIAL>\/\*       BEGIN comment;
<comment>\n         {trctx.line++;}
<comment>\*\/       BEGIN 0;
<comment>.          ;

[ \t\r\f]           ;
\n                  {trctx.line++;}
.                   return yytext[0];

"asm"[ \t\n\r]*"{"  {
                    BEGIN asmcode;
                    char *t=yytext;
                    while(t=strchr(t+1,'\n')) trctx.line++;
                    return ASM;
                    }
<asmcode>.*\n {
              char *t=yytext;
              trctx.line++;
              while ((*t==' ')||(*t=='\t')) t++;
              if (*t=='}') {yyless((t-yytext)+1); BEGIN 0; return '}';}
              char *e=yytext+yyleng-1;
              while (e[-1]=='\r') e--;
              framscriptlval.setString(SString(t,e-t));
              return ASMLINE;
              }

%%
void framscript_init_lex()
{
BEGIN 0;
yyrestart(0);
}

void framscript_cleanup_lex()
{
yy_delete_buffer(yy_current_buffer);
}
