var geneWindow =
{
    context: undefined,
    urlToXML: "f0def.xml",
    debugCreatureName: "test",
    xml: undefined,
    model: new Model(),
    part: new Part(),
    joint: new Joint(),
    neuro: new Neuro(),
    neuroConn: new NeuroConn(),
    parts: [],
    joints: [],
    neurons: [],
    neuroConns: [],
    neuroClasses: [],
    modelOne: undefined,
    _graphicsEngine: new GraphicsEngine(),
    _neuronDrawer: new NeuronDrawer(),
    downloadXML: function () {
        var local = this;
        $.ajax({
            url: "http://www.framsticks.com/files/apps/config/f0def.xml",
            dataType: "xml",
            async: false,
            success: function (xml) {
                var xmlDoc = $.parseXML(xml);
                $xml = $(xmlDoc);
                local.xml = $(xml);
            },
            error: function () {
                alert("Can't download file f0def.xml");
            }
        })
    },
    parseGeneXml: function () {
        this._parseClass($(this.xml.find("CLASS")));
        this._parseNeuroClass($(this.xml.find("NEUROCLASS")))
    },
    _parseClass: function(nodes){
        var local = this;

        nodes.each(function (entry) {
            var node = $(nodes[entry]);

            if (node.attr("NAME") == "Model") {
                local.model.setModel(node);
            }
            else if (node.attr("NAME") == "Part")
                local.part.setModel(node);
            else if (node.attr("NAME") == "Joint")
                local.joint.setModel(node);
            else if (node.attr("NAME") == "Neuro")
                local.neuro.setModel(node);
            else if (node.attr("NAME") == "NeuroConn")
                local.neuroConn.setModel(node);
            else {
                console.log("Could not recognize NAME:", node.attr("NAME"));
            }

        });
    },
    _parseNeuroClass: function(data){

        for(var i = 0; i < data.length; i++)
        {
            var neuroClass = new NeuroClass();
            neuroClass.setModel(data);
            this.neuroClasses.push(neuroClass);
        }
    },
    analyseLine: function (line) {
        //ignore comment
        if (line[0] == '#' || line == "")
            return;

        var object;
        var type = line[0];
        if (type == "p") {
            object = $.extend(true, {}, this.part);
            this.parts.push(object);
        }
        else if (type == "j") {
            object = $.extend(true, {}, this.joint);
            this.joints.push(object);
        }
        else if (type == "n") {
            object = $.extend(true, {}, this.neuro);
            this.neurons.push(object);
        }
        else if (type == "c") {
            object = $.extend(true, {}, this.neuroConn);
            this.neuroConns.push(object);
        }
        else if (type == "m") {
            object = $.extend(true, {}, this.model);
            this.modelOne = object;
        }
        else
            throw new Error("Undefined element: \"" + type + "\"");

        //remove char and ":"
        line = line.substring(2);
        var lines = line.match(/([^,"]+|"[^"]+")+/g);

        if (lines != null)
            lines.forEach(function (value) {
                value = value.trim();
                if (value == "")
                    object.setValue();
                else if (value.indexOf("=") == -1) {
                    object.setValue(value);
                }
                else {
                    var name = value.substring(0, value.indexOf("="));
                    var val = value.substring(value.indexOf("=") + 1);
                    object.setValue(name, val);
                }
            })
    },
    downloadCreature: function () {
        var lines;
        $.ajax({
            url: "http://localhost:63343/FramestickFavi/creatures/" + this.debugCreatureName + ".txt",
            async: false,
            dataType: "text",
            success: function (data) {
                lines = data.split("\n");

            },
            error: function () {
                alert("Can't download creature");
            }

        });

        //lines = $("#geno").val();
        //lines = lines.split("\n");

        return lines;
    },
    parseCreature: function () {
        var lines = this.downloadCreature();
        lines.splice(0, 1);
        var local = this;
        lines.forEach(function (value) {
            local.analyseLine(value);
        });
    },
    renderCreature: function () {

        if($("#axisBox").is(":checked"))
            this._graphicsEngine.showPartAxis();

        for (var i = 0; i < this.parts.length; i++)
            this._graphicsEngine.addPart(this.parts[i])

        for (var i = 0; i < this.joints.length; i++) {
            this._graphicsEngine.addJoint(this.joints[i]);
        }

    },
    mainLoop: function () {
        this._graphicsEngine.initializeScene();
        this.renderCreature();
        //this._graphicsEngine.debugTest();
        this._graphicsEngine.renderScene();

        this._neuronDrawer.initializeScene();
        new SmartLayout(this.neurons, this.neuroConns);
        this._neuronDrawer.drawNetwork(this.neurons, this.neuroConns, einfos);
        this._neuronDrawer.renderScene();

    }

}

function openWindow() {
    geneWindow.downloadXML();
    geneWindow.parseGeneXml();
    geneWindow.parseCreature();
    geneWindow.mainLoop();

}