// This file is a part of the Framsticks GDK.
// Copyright (C) 2002-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#ifndef _FF_GENOTYPE_H_
#define _FF_GENOTYPE_H_

#include <stdio.h>
#include "common/stl-util.h"


struct fF_growth_params
{
	int number_of_chambers;
	double scalex, scaley, scalez; //scaling factors
	double translation; //translation factor, TF range [−1; 1]
	double angle1, angle2;

	fF_growth_params()
	{
		reset();
	}

	void reset()
	{
		number_of_chambers = 1;
		scalex = scaley = scalez = 1;
		translation = 1;
		angle1 = angle2 = 0;
	}

	bool load(const char* serialized)
	{
		return sscanf(serialized, "%d %lf %lf %lf %lf %lf %lf", &number_of_chambers, &scalex, &scaley, &scalez, &translation, &angle1, &angle2) == 7;
	}

	string save()
	{
		return ssprintf("%d %f %f %f %f %f %f", number_of_chambers, scalex, scaley, scalez, translation, angle1, angle2);
	}
};


#endif
