// This file is a part of the Framsticks GDK.
// Copyright (C) 2002-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include "conv_fF.h"
#include "fF_genotype.h"
#include <frams/model/model.h>
#include <common/nonstd_stl.h>

GenoConv_fF0::GenoConv_fF0()
{
	name = "7-value Foraminifera encoding";
	in_format = 'F';
	out_format = '0';
	mapsupport = 0;
}

SString GenoConv_fF0::convert(SString &in, MultiMap *map)
{
	fF_growth_params gp;
	gp.load(in);
	Model m;
	m.open();
	// subsequent parts (chambers) are placed relative to the previous part's orientation and location
	Part *p1, *p2;
	p1 = m.addNewPart(Part::SHAPE_ELLIPSOID); //initial part
	Pt3D scaling(gp.scalex, gp.scaley, gp.scalez);
	p1->scale = scaling;

	Orient rotation = Orient_1; //must be initialized explicitly because the default Orient constructor does not initialize anything
	rotation.rotate(Pt3D(0, gp.angle1, gp.angle2)); //assumed rotation around x is 0, which is limiting if we use assymetrical shapes (i.e., not spheres). But the original model had only two angles...

	for (int i = 0; i < gp.number_of_chambers; i++, p1 = p2)
	{
		p2 = m.addNewPart(Part::SHAPE_ELLIPSOID);
		p2->scale = p1->scale.entrywiseProduct(scaling); //each part's scale is its predecessor's scale * scaling

		p2->setOrient(p1->o.transform(rotation)); //rotation transformed by p1 orientation

		// Part's tip (offset from the center) is the point at (scale.x,0,0) in part's local coordinates.
		// Get the offset in global coordinates by transforming it by the part's orientation.
		p2->p = p1->p
			+ p1->o.transform(Pt3D(p1->scale.x*gp.translation,0,0))  // p1's tip transformed
			+ p2->o.transform(Pt3D(p2->scale.x*gp.translation,0,0)); // p2's tip transformed

		m.addNewJoint(p1, p2, Joint::SHAPE_SOLID); //all parts must be connected
	}
	m.close();
	return m.getF0Geno().getGene();
}
