// This file is a part of the Framsticks GDK.
// Copyright (C) 2002-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include <frams/genetics/genman.h>
#include <frams/errmgr/stdouterr.h>

StdoutErrorHandler err;

void printGen(Geno &g)
{
	printf("Genotype: %s\nFormat: %c\nValid: %s\nComment: %s\n",
		(const char*)g.getGene(), g.getFormat(), g.isValid() ? "yes" : "no", g.getComment().len() == 0 ? "(empty)" : (const char*)g.getComment());
}

void printGenAndTitle(Geno &g, const char* title)
{
	printf("\n--------------------- %s: ---------------------\n", title);
	printGen(g);
}

/* Demonstrates various genetic operators applied to a sample genotype. See also oper_fx.cpp. */
int main(int argc, char *argv[])
{
	GenMan gm;
	gm.p_report(NULL, NULL);

	const char* src = (argc > 1) ? argv[1] : "/*9*/UUU";
	Geno gsrc(src, -1, "First");
	printGenAndTitle(gsrc, "source genotype (gsrc)");

	Geno gmut = gm.Mutate(gsrc);
	printGenAndTitle(gmut, "mutated (gmut)");

	Geno gxover = gm.CrossOver(gsrc, gmut);
	printGenAndTitle(gxover, "crossed over (gsrc and gmut)");

	Geno gsimplest = gm.GetSimplest('9');
	printGenAndTitle(gsimplest, "simplest");

	Geno ginvalid("IT'S REALLY WRONG", '9');
	printGenAndTitle(ginvalid, "invalid");

	Geno gvalidated = gm.Validate(ginvalid);
	printGenAndTitle(gvalidated, "validated");

	printf("\nHTMLized: %s\n", (const char*)gm.HTMLize((const char*)gvalidated.getGene()));

	return 0;
}
