// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 2023-2024  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#include "realloc-free0size.h"
#include <common/log.h>

// https://stackoverflow.com/questions/16759849/using-realloc-x-0-instead-of-free-and-using-malloc-with-length-of-a-string
void *realloc_free0size(void *ptr, size_t size)
{
	// special case begin
	if (ptr && size == 0)
	{
		free(ptr);
		return NULL;
	}
	// special case end

	void *tmp = realloc(ptr, size);
	if (size != 0 && tmp == NULL)
	{
		logPrintf("", "realloc_free0size", LOG_CRITICAL, "realloc(%zd) failed.", size);
	}
	return tmp;
}
