// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2023  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef _SDK_BUILD_CONFIG_H_
#define _SDK_BUILD_CONFIG_H_

#include "version.h"

#ifdef __APPLE__
  #define MACOS
#elif defined __linux || defined __CYGWIN__ || defined __MINGW32__
  #define LINUX
#endif

#ifdef __MINGW32__
  #undef _WIN32 //assume that someone using MinGW to compile this SDK wants to pretend their system is Linux, not Windows
#endif



#ifdef _WIN32
#define WANTED_FP_EXCEPTIONS (fpExcept::FPEX_DIV0 | fpExcept::FPEX_INVALID | fpExcept::FPEX_OVERFLOW) // EM_DENORMAL | EM_UNDERFLOW | EM_INEXACT; //commented out exceptions occur during proper operation
#else
#define WANTED_FP_EXCEPTIONS fpExcept::FPEX_DIV0 // | fpExcept::FPEX_INVALID | fpExcept::FPEX_OVERFLOW -> still wanted but we need TODO use try catch in ExtValue!
#endif

#define USE_PRINTFLOAT_DRAGON4
#define NOCREATUREOBJECT
#define SDK_WITHOUT_FRAMS
#define NO_BARRIER
#define NO_VMACHINE

#define NEURO_IMPL_FILES "neuroimplfiles-SDK.h"
#define NEURO_CLS_FACTORY "neurocls-f0-SDK-factory.h"
#define NEURO_CLS_LIBRARY "neurocls-f0-SDK-library.h"
#define F0_DEFASSIGN_FILE "defassign-f0-SDK.h"
#define F0_CLASSES_FILE "f0-SDK-classes.h"
#define GEN_CONFIG_FILE "gen-config-SDK.h"

#endif
