#include "defgenoconv.h"

#include GEN_CONFIG_FILE

#ifdef USE_GENCONV_F10
#include "conv/conv_f1.h"
#endif
#ifdef USE_GENCONV_F20
#include "conv/conv_f2.h"
#endif
#ifdef USE_GENCONV_F32
#include "conv/conv_f3.h"
#endif
#ifdef USE_GENCONV_F40
#include "conv/conv_f4.h"
#endif
#ifdef USE_GENCONV_F41_TEST
#include "conv/conv_f4.h"
#endif
#ifdef USE_GENCONV_F50
#include "conv/conv_f5.h"
#endif
#ifdef USE_GENCONV_F60
#include "conv/geno_f6.h"
#endif
#ifdef USE_GENCONV_F70
#include "conv/conv_f7.h"
#endif
#ifdef USE_GENCONV_F81
#include "conv/conv_f8tof1.h"
#endif
#ifdef USE_GENCONV_F90
#include "conv/conv_f9.h"
#endif

DefaultGenoConvManager::DefaultGenoConvManager()
{
#ifdef USE_GENCONV_F10
addConverter(new GenoConv_F1());
#endif
#ifdef USE_GENCONV_F20
addConverter(new GenoConv_F20());
#endif
#ifdef USE_GENCONV_F32
addConverter(new GenoConv_F32());
#endif
#ifdef USE_GENCONV_F40
addConverter(new GenoConv_F40());
#endif
#ifdef USE_GENCONV_F41_TEST
addConverter(new GenoConv_F41_TestOnly());
#endif
#ifdef USE_GENCONV_F50
addConverter(new GenoConv_F50);
#endif
#ifdef USE_GENCONV_F60
addConverter(new GenoConv_F60);
#endif
#ifdef USE_GENCONV_F70
addConverter(new GenoConv_F70);
#endif
#ifdef USE_GENCONV_F81
addConverter(new GenoConv_F8ToF1());
#endif
#ifdef USE_GENCONV_F90
addConverter(new GenoConv_F90);
#endif

param.updatetab();
}
