from evolalg.selection.selection import Selection
from deap import tools
import copy


class NSGA2Selection(Selection):
    def __init__(self, copy=False, *args, **kwargs):
        super(NSGA2Selection, self).__init__(*args, **kwargs, copy=copy)

    def call(self, population, count=None):
        super(NSGA2Selection, self).call(population)
        pop = tools.selNSGA2(population, len(population))
        # TODO make count divisible by 4, is this the best way to do it/is it absolutely required? if this is applied, why popsize must still be a multiple of 4?
        remainder=count % 4
        if remainder > 0:
            count += 4-remainder   
        return copy.deepcopy(tools.selTournamentDCD(pop, count)) # "The individuals sequence length has to be a multiple of 4 only if k is equal to the length of individuals"
