// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2021  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#ifndef DISTRIBUTION_MEASURE_H
#define DISTRIBUTION_MEASURE_H

#include "simil-measure-base.h"
#include "EMD/emd.h"
#include <random>

class SimilMeasureDistribution : public SimilMeasureBase
{
public:
	SimilMeasureDistribution();
	~SimilMeasureDistribution() {};
	int setParams(std::vector<double> params);
	void calculateFuns();
	void calculateFun(std::pair<double, float> *fun, const Model &sampled);
	double compareFuns();
	double EMD(std::pair<double, float> *fun1, std::pair<double, float> *fun2);
	double density;
	int samples_num;
	int bin_num;
	/// Interface to local parameters
	Param localpar;

protected:
	std::pair<double, float> *funs[2];
	SolidsShapeTypeModel *sst_models[2];
	void (SimilMeasureDistribution::*distribution_fun)(int samples_taken, std::uniform_int_distribution<> &distribution, const Model &sampled, std::vector<double> &dist_vect);

	void fillPointsWeights(std::pair<double, float> *fun, feature_t *points, float *weights);
	double getDistance();
	void D2(int samples_taken, std::uniform_int_distribution<> &distribution, const Model &sampled, std::vector<double> &dist_vect);
	void D1(int samples_taken, std::uniform_int_distribution<> &distribution, const Model &sampled, std::vector<double> &dist_vect);
	void D3(int samples_taken, std::uniform_int_distribution<> &distribution, const Model &sampled, std::vector<double> &dist_vect);
	void D4(int samples_taken, std::uniform_int_distribution<> &distribution, const Model &sampled, std::vector<double> &dist_vect);
	void A3(int samples_taken, std::uniform_int_distribution<> &distribution, const Model &sampled, std::vector<double> &dist_vect);

private:
	std::mt19937 rndgen;
};

#endif /* DISTRIBUTION_MEASURE_H */

