<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/">
  <html><body>
      <xsl:apply-templates select="//framscript"/>
  </body></html>
</xsl:template>

<xsl:template match="framscript">
  <h1>Framscript Objects</h1>
  <xsl:apply-templates select="//framscript/type"/>
</xsl:template>

<xsl:template match="type">
  <hr/>
  <table width="100%"><tr><td width="50%" valign="top">
  <h2><xsl:value-of select="@name"/></h2>
  <i>defined in <xsl:value-of select="@context"/></i><br/><br/>
  <xsl:value-of select="description/."/>
  </td><td valign="top">
  <ul><xsl:apply-templates select="element"/></ul>
  </td></tr></table>
</xsl:template>

<xsl:template match="element">
  <li><xsl:choose><xsl:when test="@deprecated='true'"><strike><xsl:value-of select="@name"/></strike></xsl:when><xsl:otherwise><b><xsl:value-of select="@name"/></b></xsl:otherwise></xsl:choose> - 
   <xsl:if test="@function='true'">
    function <xsl:if test="@type!=''">returning <xsl:value-of select="@type"/></xsl:if>
    <br/><xsl:value-of select="description/."/>
    
    <xsl:if test="count(arguments)!='0'">
     <ul><xsl:if test="count(arguments/argument)='0'"><u>No arguments</u></xsl:if>
        <xsl:if test="count(arguments/argument)!='0'"><u>Arguments:</u><xsl:apply-templates select="arguments/argument"/></xsl:if></ul></xsl:if>
    </xsl:if>
   <xsl:if test="not(@function='true')">
    <xsl:value-of select="@type"/> field
    <xsl:if test="description/. != ''"><br/><xsl:value-of select="description/."/></xsl:if>
   </xsl:if>
  </li>
</xsl:template>

<xsl:template match="argument">
  <li><b><xsl:value-of select="@name"/></b> - <xsl:value-of select="@type"/></li>
</xsl:template>

</xsl:stylesheet>
