package com.framsticks.model;

import java.io.InputStream;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import com.framsticks.params.FramsClass;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.params.SourceInterface;
import com.framsticks.params.ValueParam;
import com.framsticks.parsers.FileSource;
import com.framsticks.parsers.Loaders;
import com.framsticks.test.TestConfiguration;

import static org.fest.assertions.Assertions.*;

@Test
public class ModelPackageTest extends TestConfiguration {

	@Test(dataProvider = "classesList")
	public void testFramsClass(Class<?> javaClass, String name, int paramCount, Object[][] paramsTests) throws InstantiationException, IllegalAccessException {
		String filename = "/info/" + name + ".info";
		InputStream stream = ModelPackage.class.getResourceAsStream(filename);
		assertThat(stream).describedAs("stream " + filename).isNotNull();

		SourceInterface source = new FileSource(stream, filename);

		assertThat(source.isClosed()).isFalse();
		FramsClass framsClass = Loaders.loadFramsClass(source);
		assertThat(framsClass).isNotNull();

		assertThat(framsClass.getParamCount()).isEqualTo(paramCount);
		ReflectionAccess access = new ReflectionAccess(javaClass, framsClass);
		Object object = javaClass.newInstance();
		access.select(object);

		if (paramsTests != null) {
			for (Object[] args : paramsTests) {
				String paramName = (String )args[0];
				Object defaultValue = args[1];

				ValueParam param = framsClass.getParamEntry(paramName, ValueParam.class);
				assertThat(param.getDef(Object.class)).isEqualTo(defaultValue);

			}
		}
	}

	@DataProvider
	public Object[][] classesList() {
		return new Object[][] {
			{ MechPart.class, "MechPart", 20 , null},
			{ Joint.class, "Joint", 16 , null},
			{ MechJoint.class, "MechJoint", 10 , null},
			{ Neuro.class, "Neuro", 21, null},
			{ NeuroDefinition.class, "NeuroDef", 9, null},
			{ Part.class, "Part", 18, new Object[][] {{"m", 1.0}}},
			// { Model.class, "Model", null},
			{ Creature.class, "Creature", 64, null},
			{ Genotype.class, "Genotype", 37, null},
			{ World.class, "World", 10, null}
		};
	}
}
