package com.framsticks.hosting;

// import org.apache.log4j.Logger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.testng.annotations.Test;

import com.framsticks.core.ListChange;
import com.framsticks.core.LocalTree;
import com.framsticks.core.Path;
import com.framsticks.core.TreeOperations;
import com.framsticks.core.XmlBasedTest;
import com.framsticks.remote.RemoteTree;

import com.framsticks.test.ChangeEvent;
import com.framsticks.test.TestClass;
import com.framsticks.core.Tree;
import com.framsticks.params.FramsClass;
import com.framsticks.params.Access;
import com.framsticks.params.EventListener;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.PropertiesAccess;
import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.StringParam;
// import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.util.dispatching.Dispatching.Waiter;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.RunAt;

import static com.framsticks.core.TreeOperations.*;

import static org.fest.assertions.Assertions.*;

@Test
public class ServerTest extends XmlBasedTest {

	protected RemoteTree remote;
	protected FramsClass remoteTestFramsClass;
	protected Path remotePath;

	protected Server server;
	protected LocalTree hosted;
	protected TestClass hostedObject;
	protected EventListener<ChangeEvent> listener;
	protected EventListener<ListChange> childListener;

	protected List<String> listenerArguments = new LinkedList<>();
	protected List<ListChange> childrenChanges = new LinkedList<>();


	@Override
	protected String getConfigurationName() {
		return "ServerTest.xml";
	}

	@Test
	public void runServer() {
		assertThat(framsticks.size()).isEqualTo(2);
		assertThat(framsticks.get("test")).isInstanceOf(Server.class);
		assertThat(framsticks.get("remote")).isInstanceOf(RemoteTree.class);

		server = (Server) framsticks.get("test");
		remote = (RemoteTree) framsticks.get("remote");
		assertThat(server.getHosted()).isInstanceOf(LocalTree.class);
		hosted = (LocalTree) server.getHosted();
		assertThat(hosted.getRootObject()).isInstanceOf(TestClass.class);
		hostedObject = hosted.getRootObject(TestClass.class);
	}

	@Test(dependsOnMethods = "runServer")
	public void fetchInfo() {
		final Waiter waiter = produceWaiter(1.0);

		TreeOperations.tryGet(remote, "/testClass", new FutureHandler<Path>(failOnException) {
			@Override
			protected void result(Path path) {
				assertThat(path.isResolved()).isTrue();
				remoteTestFramsClass = bindAccess(path).getFramsClass();
				assertThat(remoteTestFramsClass.getName()).isEqualTo("TestClass");
				waiter.pass();
			}
		});

	}

	@Test(dependsOnMethods = "fetchInfo")
	public void resolveAndfetchRootObject() {
		final Waiter waiter = produceWaiter(1.0);

		TreeOperations.tryGet(remote, "/testClass", new FutureHandler<Path>(failOnException) {
			@Override
			protected void result(Path path) {
				assertThat(path.isResolved()).isTrue();
				remotePath = path;
				Access access = bindAccess(path);
				assertThat(access).isInstanceOf(PropertiesAccess.class);
				assertThat(access.get("name", String.class)).isEqualTo("a test name");
				waiter.pass();
			}
		});
	}

	@Test(dependsOnMethods = "resolveAndfetchRootObject")
	public void setValueName() {
		final Waiter waiter = produceWaiter(2.0);

		set(remotePath, remoteTestFramsClass.getParamEntry("name", PrimitiveParam.class), "new name", new FutureHandler<Integer>(failOnException) {
			@Override
			protected void result(Integer flags) {
				// assertThat(flags).isEqualTo(0);
				/** And now check directly whether it was really set. */
				hosted.dispatch(new RunAt<Tree>(failOnException) {
					@Override
					protected void runAt() {
						assertThat(hostedObject.getName()).isEqualTo("new name");
						waiter.pass();
					}
				});
			}
		});
	}

	@Test(dependsOnMethods = "setValueName")
	public void registerListener() {
		final Waiter waiter = produceWaiter(1.0);
		listener = new EventListener<ChangeEvent>() {

			@Override
			public void action(ChangeEvent argument) {
				listenerArguments.add(argument.history);
			}
		};

		TreeOperations.tryGet(remote, "/cli/events", new FutureHandler<Path>(failOnException) {
			@Override
			protected void result(Path path) {
				waiter.pass();
			}
		});

		addListener(remotePath, remoteTestFramsClass.getParamEntry("history_changed", EventParam.class), listener, ChangeEvent.class, produceWaiter(1.0).passInFuture(Void.class));
	}

	@Test(dependsOnMethods = "registerListener")
	public void callMethod() {
		final Waiter waiter = produceWaiter(2.0);

		call(remotePath, remoteTestFramsClass.getParamEntry("resetHistory", ProcedureParam.class), new Object[] {}, produceWaiter(2.0).passInFuture(Object.class));

		call(remotePath, remoteTestFramsClass.getParamEntry("appendHistory", ProcedureParam.class), new Object[] {"next word"}, new FutureHandler<Object>(failOnException) {
			@Override
			protected void result(Object result) {
				hosted.dispatch(new RunAt<Tree>(failOnException) {
					@Override
					protected void runAt() {
						assertThat(hostedObject.getHistory()).isEqualTo("next word|");
						waiter.pass();
					}
				});
			}
		});
	}


	@Test(dependsOnMethods = "callMethod")
	public void deregisterListener() {
		removeListener(remotePath, remoteTestFramsClass.getParamEntry("history_changed", EventParam.class), listener, produceWaiter(1.0).passInFuture(Void.class));

		assertThat(listenerArguments).isEqualTo(Arrays.asList("", "next word|"));
	}


	@Test(dependsOnMethods = "deregisterListener")
	public void registerChildListener() {

		childListener = new EventListener<ListChange>() {
			@Override
			public void action(ListChange listChange) {
				childrenChanges.add(listChange);
			}
		};

		addListener(remotePath, remoteTestFramsClass.getParamEntry("children_changed", EventParam.class), childListener, ListChange.class, produceWaiter(1.0).passInFuture(Void.class));
	}

	@Test(dependsOnMethods = "registerChildListener")
	public void createChild() {
		final Waiter waiter = produceWaiter(2.0);
		call(remotePath, "createChild", new Object[] { "a child" }, produceWaiter(2.0).passInFuture(Object.class));
		call(remotePath, "createChild", new Object[] { "another child" }, produceWaiter(2.0).passInFuture(Object.class));

		tryGet(remote, "/testClass/children/c0", new FutureHandler<Path>(failOnException) {

			@Override
			protected void result(Path result) {
				set(result, getFramsClass(result).getParamEntry("name", StringParam.class), "new_name", new FutureHandler<Integer>(failOnException) {

					@Override
					protected void result(Integer result) {
						waiter.pass();
					}
				});
			}
		});
	}

	@Test(dependsOnMethods = "createChild")
	public void deregisterChildListener() {
		removeListener(remotePath, remoteTestFramsClass.getParamEntry("children_changed", EventParam.class), childListener, produceWaiter(1.0).passInFuture(Void.class));
	}

	@Test(dependsOnMethods = "deregisterChildListener")
	public void checkListChanges() {
		assertThat(childrenChanges).isEqualTo(Arrays.asList(
			new ListChange(ListChange.Action.Add, 0, "c0"),
			new ListChange(ListChange.Action.Add, 1, "c1"),
			new ListChange(ListChange.Action.Modify, 0, "c0")
		));
	}

	@Test(dependsOnMethods = "checkListChanges")
	public void endWait() {
		monitor.useFor(1.0);
	}
}
