package com.framsticks.gui;

import static org.fest.assertions.Assertions.assertThat;

import org.testng.annotations.Test;

import com.framsticks.core.Tree;
import com.framsticks.core.LocalTree;
import com.framsticks.model.Model;
import com.framsticks.params.types.FloatParam;
import com.framsticks.parsers.XmlLoader;
import com.framsticks.util.dispatching.RunAt;

import static com.framsticks.core.TreeOperations.*;

@Test
public class LocalTreeBrowserTest extends BrowserBaseTest {

	LocalTree tree;

	@Override
	protected void configureBrowser() {
		browser = new XmlLoader().load(Browser.class, getClass().getResourceAsStream("/configs/LocalTreeBrowserTest.xml"));

		assertThat(browser.getTrees().size()).isEqualTo(1);
		assertThat(browser.getTrees().get("model")).isInstanceOf(LocalTree.class);

		tree = (LocalTree) browser.getTrees().get("model");
	}

	@Test(timeOut = 30000)
	public void testShow() {
		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				assertThat(tree.getRootObject()).isInstanceOf(Model.class);
			}
		});

		clickAndExpandPath("model");
		clickAndExpandPath("model/parts");
		clickAndExpandPath("model/parts/2");

		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				assertThat(bindAccess(tree, "/parts/2").getFramsClass().getParamEntry("m", FloatParam.class).getMax(Double.class)).isEqualTo(999.0);
			}
		});

	}


}
