package com.framsticks.util.dispatching;

import com.framsticks.util.FramsticksException;

public class DispatchingFuture<C, T> extends Future<T> {

	protected final Dispatcher<? super C> dispatcher;
	protected final Future<T> future;

	/**
	 * @param dispatcher
	 * @param future
	 */
	public DispatchingFuture(Dispatcher<? super C> dispatcher, Future<T> future) {
		this.dispatcher = dispatcher;
		this.future = future;
	}

	@Override
	public void handle(final FramsticksException exception) {
		Dispatching.dispatchIfNotActive(dispatcher, new RunAt<C>(ThrowExceptionHandler.getInstance()) {
			@Override
			protected void runAt() {
				future.handle(exception);
			}
		});
	}

	@Override
	protected void result(final T result) {
		Dispatching.dispatchIfNotActive(dispatcher, new RunAt<C>(future) {
			@Override
			protected void runAt() {
				future.pass(result);
			}
		});
	}

	public static <Ca, Ta> Future<Ta> create(Dispatcher<Ca> dispatcher, Future<Ta> future) {
		return new DispatchingFuture<Ca, Ta>(dispatcher, future);
	}

}
