package com.framsticks.parsers;

import com.framsticks.model.Genotype;
import com.framsticks.params.*;
import com.framsticks.params.types.*;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import static com.framsticks.params.ParamFlags.*;

public class GenotypeLoader extends MultiParamLoader {
	private Genotype genotypeReturnObject = new Genotype();
	private static Logger logger = LogManager.getLogger(GenotypeLoader.class);

	public GenotypeLoader() throws Exception {

		FramsClass entries = FramsClass.build()
			.name("Genotype")
			.id("org")
			.description("A Genotype with the associated performance information. All but one Genotype objects are placed in Genotype Groups. There is also a single static Genotype object not associated with a group, which is used as a temporary storage by genetic operators and some functions from GenePools.")
			.group("Body")
			.group("Performance")
			.group("Fitness")
			.group("Conversions")
			.param(Param.build().id("name").group(0).name("Name").type(StringParam.class).min(0).max(40))
			.param(Param.build().id("genotype").group(0).name("Genotype").type(StringParam.class).min(1))
			.param(Param.build().id("info").group(0).name("Info").type(StringParam.class).min(1).help("Additional information or comments"))
			.param(Param.build().id("simi").group(1).flags(READONLY | DONTSAVE).name("Similarity").type(FloatParam.class))
			.param(Param.build().id("energ0").group(1).flags(READONLY | DONTSAVE).name("Starting energy").type(FloatParam.class))
			.param(Param.build().id("strsiz").group(1).flags(READONLY | DONTSAVE | USERHIDDEN).name("Body parts (deprecated; use numparts)").type(FloatParam.class))
			.param(Param.build().id("strjoints").group(1).flags(READONLY | DONTSAVE | USERHIDDEN).name("Body joints (deprecated; use numjoints)").type(FloatParam.class))
			.param(Param.build().id("nnsiz").group(1).flags(READONLY | DONTSAVE | USERHIDDEN).name("Brain size (deprecated; use numneurons)").type(FloatParam.class))
			.param(Param.build().id("nncon").group(1).flags(READONLY | DONTSAVE | USERHIDDEN).name("Brain connections (deprecated; use numconnections)").type(FloatParam.class))
			.param(Param.build().id("numparts").group(1).flags(READONLY | DONTSAVE).name("Body parts").type(FloatParam.class))
			.param(Param.build().id("numjoints").group(1).flags(READONLY | DONTSAVE).name("Body joints").type(FloatParam.class))
			.param(Param.build().id("numneurons").group(1).flags(READONLY | DONTSAVE).name("Brain size").type(FloatParam.class))
			.param(Param.build().id("numconnections").group(1).flags(READONLY | DONTSAVE).name("Brain connections").type(FloatParam.class))
			.param(Param.build().id("num").group(2).name("Ordinal number").type(DecimalParam.class))
			.param(Param.build().id("gnum").group(2).name("Generation").type(DecimalParam.class))
			.param(Param.build().id("popsiz").group(2).flags(USERHIDDEN).name("Deprecated; use entities").type(DecimalParam.class))
			.param(Param.build().id("entities").group(2).flags(DONTSAVE).name("Instances").type(DecimalParam.class).help("Copies of this genotype"))
			.param(Param.build().id("lifespan").group(2).name("Life span").type(FloatParam.class).help("Average life span"))
			.param(Param.build().id("velocity").group(2).name("Velocity").type(FloatParam.class).help("Average velocity"))
			.param(Param.build().id("distance").group(2).name("Distance").type(FloatParam.class))
			.param(Param.build().id("vertvel").group(2).name("Vertical velocity").type(FloatParam.class))
			.param(Param.build().id("vertpos").group(2).name("Vertical position").type(FloatParam.class))
			.param(Param.build().id("fit").group(3).flags(READONLY | DONTSAVE).name("Fitness").type(FloatParam.class))
			.param(Param.build().id("fit2").group(3).flags(READONLY | DONTSAVE).name("Final fitness").type(FloatParam.class).help("Fitness shifted by (avg-n*stddev)"))
			.param(Param.build().id("f0genotype").group(4).flags(READONLY | DONTSAVE).name("f0 genotype").type(StringParam.class).min(1).help("converted to f0 genotype"))
			.param(Param.build().id("user1").group(2).name("User field 1").type(UniversalParam.class))
			.param(Param.build().id("user2").group(2).name("User field 2").type(UniversalParam.class))
			.param(Param.build().id("user3").group(2).name("User field 3").type(UniversalParam.class))
			.param(Param.build().id("isValid").group(0).flags(READONLY | DONTSAVE | USERHIDDEN).name("Valid").type(DecimalParam.class).min(0).max(1))
			.param(Param.build().id("uid").group(0).flags(READONLY | USERHIDDEN).name("#").type("s").help("Unique identifier"))
			.finish();

		Access reflectionParam = new PropertiesAccess(entries);
		addAccess(reflectionParam);
		addBreakCondition(Status.AfterObject);
	}

	public Genotype loadNextGenotype() throws Exception {
		logger.info("Loading next genotype");
		Status result = go();

		if (result == Status.AfterObject) {
			return genotypeReturnObject;
		}

		return null;
	}
}
