package com.framsticks.parsers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import com.framsticks.params.annotations.AutoAppendAnnotation;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.util.AutoBuilder;

@FramsClassAnnotation
public class AutoInjector implements AutoBuilder {

	protected final List<Object> objects = new LinkedList<>();

	@Override
	public List<Object> autoFinish() {
		return Collections.unmodifiableList(objects);
	}

	@AutoAppendAnnotation
	public void append(Object object) {
		objects.add(object);
	}

}
