package com.framsticks.gui.tree;


import com.framsticks.gui.AbstractPanel;
import com.framsticks.gui.Frame;
import com.framsticks.gui.ImageProvider;
import com.framsticks.params.CompositeParam;

public class EmptyNode extends AbstractNode {

	protected final CompositeParam param;
	protected final Frame frame;

	/**
	 * @param param
	 */
	public EmptyNode(Frame frame, CompositeParam param) {
		this.param = param;
		this.frame = frame;
	}

	@Override
	public int getChildCount() {
		return 0;
	}

	@Override
	public Object getChild(int number) {
		return null;
	}

	@Override
	public int getIndexOfChild(Object child) {
		return -1;
	}

	@Override
	public boolean isLeaf() {
		return false;
	}

	@Override
	public void render(TreeCellRenderer renderer) {
		// TODO Auto-generated method stub

		renderer.setToolTipText("?");
		renderer.setText(param.getId());
		renderer.setIcon(ImageProvider.loadImage(ImageProvider.FOLDER_CLOSED));
	}

	/**
	 * @return the param
	 */
	public CompositeParam getParam() {
		return param;
	}

	@Override
	public AbstractPanel getPanel() {
		return frame.getEmptyPanel();
	}

}
