package com.framsticks.gui.table;


import com.framsticks.gui.ModifiablePanel;
import com.framsticks.params.Access;
import com.framsticks.params.ListAccess;
import com.framsticks.params.Param;
import com.framsticks.util.FramsticksException;
import com.framsticks.util.lang.Casting;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import javax.swing.*;

/**
 * Panel contains table and allows to manages displaying columns.
 */
@SuppressWarnings("serial")
public class ListPanel extends ModifiablePanel {

	private static final Logger log = LogManager.getLogger(ListPanel.class.getName());

	protected final TableModel tableModel;
	protected final JTable table;
	protected final JScrollPane scrollPane;

	public ListPanel(Parameters parameters, ListPanelProvider provider) {
		super(parameters);

		final ColumnsConfig config = provider.getColumnsConfigs().get(framsClass.getName());
		log.debug("creating ListPanel for {} using config {}", parameters.framsClass, config);

		tableModel = new TableModel(this);
		if (config != null) {
			for (String id : config.getColumnsNames()) {
				Param param = framsClass.getParam(id);
				if (param == null) {
					throw new FramsticksException().msg("requested param not found in frams class").arg("param", id).arg("frams class", framsClass);
				}
				if (!tableModel.addColumnIfSupported(param)) {
					throw new FramsticksException().msg("param is not supported in table view").arg("param", param).arg("frams class", framsClass);
				}
			}
		} else {
			for (Param param : framsClass.getParamEntries()) {
				if (provider.getMaximumColumnNumber() != null && tableModel.getColumnCount() >= provider.getMaximumColumnNumber()) {
					break;
				}
				tableModel.addColumnIfSupported(param);
			}
		}

		table = new JTable(tableModel);
		tableModel.setupTable();

		scrollPane = new JScrollPane(table);
		setupContentComponent(scrollPane);

		table.getTableHeader().setReorderingAllowed(false);
		table.setColumnSelectionAllowed(false);
		table.setCellSelectionEnabled(false);
		table.setColumnSelectionAllowed(false);

		this.revalidate();
	}


	@Override
	protected void applyChanges() {
	}

	@Override
	public void pullValuesFromLocalToUser(Access access) {
		tableModel.attachSource(Casting.throwCast(ListAccess.class, access));
	}

	@Override
	public String getTitle() {
		return "List";
	}

	/**
	 * @return the table
	 */
	public JTable getTable() {
		return table;
	}
}
