package com.framsticks.gui.table;



import com.framsticks.params.Param;

public abstract class Column {

	protected final Param param;
	protected final TableModel tableModel;

	/**
	 * @param param
	 */
	public Column(Param param, TableModel tableModel) {
		this.param = param;
		this.tableModel = tableModel;
	}

	/**
	 * @return the param
	 */
	public Param getParam() {
		return param;
	}

	public abstract Class<?> getColumnClass();
	public abstract Object getValueAt(int rowIndex);

	@Override
	public String toString() {
		return "column for " + param;
	}

	public abstract int setValueAt(int rowIndex, Object value);

	public abstract boolean isEditable();


}
