package com.framsticks.gui.controls;

import com.framsticks.core.Path;
import com.framsticks.gui.Frame;
import com.framsticks.gui.Gui;
import com.framsticks.params.Param;
import com.framsticks.params.ValueParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.util.dispatching.ExceptionResultHandler;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.ThrowExceptionHandler;
import com.framsticks.util.swing.TooltipConstructor;

import javax.swing.*;
import javax.swing.border.BevelBorder;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("serial")
public class ProcedureControl extends Control implements ControlOwner {

	private static final Logger log = LogManager.getLogger(ProcedureControl.class);

	protected final JButton procedureButton;

	final protected Map<ValueParam, ValueControl> components = new IdentityHashMap<>();

	public ProcedureControl(ProcedureParam procedureParam) {
		super(procedureParam);

		this.setToolTipText(new TooltipConstructor()
			.append("name", procedureParam.getName())
			.append("id", procedureParam.getId())
			.append("help", procedureParam.getHelp())
			.build());

		procedureButton = new JButton("Call");
		procedureButton.setName("call");

		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

		Gui.fillWithControls(this, procedureParam.getArgumentsType(), components, ValueControl.class);

		if (components.size() != procedureParam.getArgumentsType().size()) {
			procedureButton.setEnabled(false);
		}
		if (!components.isEmpty()) {
			this.setBorder(new BevelBorder(BevelBorder.RAISED));
		}

		procedureButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {

				final Path path = getCurrentPath();

				final List<Object> arguments = new LinkedList<Object>();
				for (Param arg : getParam().getArgumentsType()) {
					Object value = components.get(arg).getCurrentValue();
					arguments.add(value);
					log.debug("argument {}: {}", arg, value);
				}
				//TODO FEH: make it show dialog
				callProcedure(path, getParam(), arguments.toArray());

			}
		});
		this.add(procedureButton);

	}

	public static void callProcedure(final Path path, final ProcedureParam param, Object[] arguments) {
		final ExceptionResultHandler handler = ThrowExceptionHandler.getInstance();

		assert path.getTree().isActive();

		path.getTree().call(path, param, arguments, new FutureHandler<Object>(handler) {

			@Override
			public void result(Object result) {

			}
		});
	}

	@Override
	public JPanel getPanelForControls() {
		return this;
	}

	@Override
	public ProcedureParam getParam() {
		return (ProcedureParam) param;
	}

	@Override
	protected void updateEnabled(boolean enabled) {
		procedureButton.setEnabled(enabled);
		for (ValueControl vc : components.values()) {
			vc.setUserEnabled(enabled);
		}
	}

	@Override
	public Frame getFrame() {
		return owner.getFrame();
	}

	@Override
	public Path getCurrentPath() {
		return owner.getCurrentPath();
	}

}
