package com.framsticks.gui.controls;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import com.framsticks.params.types.EventParam;

/**
 * @author Piotr Sniegowski
 */
@SuppressWarnings("serial")
public class EventControl extends Control {
	// private static final Logger log = LogManager.getLogger(EventControl.class.getName());

	protected final JButton button;
	boolean subscribed = true;

	public EventControl(final EventParam eventParam) {
		super(eventParam);

		button = new JButton("subscribe");
		this.add(button);
		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Control.LINE_HEIGHT));

		button.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (subscribed) {
					//panel.getCurrentTreeNode().unsubscribe(eventParam);
				} else {
					//panel.getCurrentTreeNode().subscribe(eventParam);
				}
			}
		});

	}

	@Override
	protected void updateEnabled(boolean enabled) {
		button.setEnabled(enabled);
	}

	/*
	@Override
	public void refresh() {
		subscribed = panel.getCurrentTreeNode().hasSubscribed((EventParam)param);
		button.setText(subscribed ? "unsubscribe" : "subscribe");
		this.revalidate();
	}
	*/
}
