package com.framsticks.gui;

import com.framsticks.core.Path;
import com.framsticks.gui.controls.Control;
import com.framsticks.gui.controls.ControlOwner;
import com.framsticks.gui.controls.ValueControl;
import com.framsticks.gui.controls.ValueControlListener;
import com.framsticks.params.Access;
import com.framsticks.params.Param;
import com.framsticks.params.ValueParam;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import javax.swing.*;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import static com.framsticks.util.lang.Containers.filterInstanceof;

import com.framsticks.util.FramsticksException;

@SuppressWarnings("serial")
public class ObjectPanel extends ModifiablePanel implements ControlOwner {

	private static final Logger log = LogManager.getLogger(ObjectPanel.class);

	final protected Map<Param, Control> components = new IdentityHashMap<Param, Control>();
	final protected Map<ValueParam, ValueControl> valueControls = new IdentityHashMap<ValueParam, ValueControl>();

	protected final JPanel contentPanel;
	protected final JScrollPane scrollPane;

	public ObjectPanel(TreePanel.Parameters parameters, Collection<Param> params) {
		super(parameters);

		contentPanel = new JPanel();
		scrollPane = new JScrollPane(contentPanel);
		contentPanel.setLayout(new BoxLayout(contentPanel, BoxLayout.PAGE_AXIS));
		setupContentComponent(scrollPane);

		Gui.fillWithControls(this, params, components, Control.class);
		setName(framsClass.getId());

		for (final ValueControl c : filterInstanceof(components.values(), ValueControl.class)) {
			valueControls.put(c.getParam(), c);
			c.setUserEnabled(true);
			c.setListener(new ValueControlListener() {
				@Override
				public boolean onChange(Object newValue) {
					if (currentPath == null) {
						return true;
					}
					boolean result = treeAtFrame.changeValue(currentPath.assureResolved().getTopObject(), c, newValue);
					refreshControlButtons();
					return result;
				}
			});
		}

		contentPanel.add(Box.createVerticalGlue());
		this.revalidate();
	}

	@Override
	protected void applyChanges() {
		assert frame.isActive();
		assert currentPath != null;
		treeAtFrame.pushLocalChanges(currentPath);
	}

	protected void refreshControlButtons() {
		assert frame.isActive();
		applyButton.setEnabled(treeAtFrame.hasLocalChanges(currentPath.getTopObject()));
	}

	@Override
	public void pullValuesFromLocalToUser(Access access) {
		assert currentPath != null;
		log.debug("refreshing components");

		final Map<ValueControl, Object> values = new IdentityHashMap<ValueControl, Object>();
		for (Map.Entry<ValueParam, ValueControl> e : valueControls.entrySet()) {
			values.put(e.getValue(), access.get(e.getKey().getId(), Object.class));
		}


		NodeAtFrame nodeAtFrame = treeAtFrame.getLocalInfo(currentPath.getTopObject());
		if (nodeAtFrame != null) {
			for (Map.Entry<ValueControl, Object> e : nodeAtFrame.localChanges.entrySet()) {
				values.put(e.getKey(), e.getValue());
			}
		}

		for (Map.Entry<ValueControl, Object> e : values.entrySet()) {
			e.getKey().pushValueToUserInterface(e.getValue());
		}
		refreshControlButtons();
		ObjectPanel.this.revalidate();

	}

	@Override
	public String getTitle() {
		return "Properties";
	}

	@Override
	public JPanel getPanelForControls() {
		return contentPanel;
	}

	@Override
	public void handle(FramsticksException exception) {
		frame.handle(exception);
	}

	@Override
	public Path getCurrentPath() {
		return super.getCurrentPath();
	}

}
