package com.framsticks.gui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.WindowConstants;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.util.swing.MenuConstructor;

/**
 * Application Main Frame.
 */
@SuppressWarnings("serial")
public class MainFrame extends Frame {

	private final static Logger log = LogManager.getLogger(MainFrame.class.getName());

	JButton start, stop, step;

	/**
	 * Builds main frame.
	 */
	public MainFrame(final Browser browser) {
		super(browser);
		setTitle("framsticks");
		log.debug("creating main frame");

	}


	@Override
	protected void initializeGui() {
		super.initializeGui();

		new MenuConstructor(fileMenu)
			.add(null, new AbstractAction("Console") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
					// showConsoleFrame();
				}
			})
			.add(KeyStroke.getKeyStroke(KeyEvent.VK_G, ActionEvent.CTRL_MASK), new AbstractAction("Goto") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
					browser.autoResolvePath("/simulator/genepools/groups/0", null);
					// browser.autoResolvePath("/simulator/populations/groups/0", null;
					// browser.autoResolvePath("/simulator/genepools/groups/0/genotypes", null);
					// browser.autoResolvePath("/simulator/populations/groups", null);
				}
			})
			.add(null, new AbstractAction("Disconnect") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
					disconnect();
				}
			})
			.add(null, new AbstractAction("Quit") {
				@Override
				public void actionPerformed(ActionEvent actionEvent) {
				}
			})
			;

		setFrameProperties();
	}

	// private void onConnectionEstablished() {
		// assert isActive();

		// addNodeActionToTreePopupMenu("Open in console", new NodeAction() {
			// @Override
			// public void actionPerformed(TreeNode treeNode) {
				// assert isActive();
			// }
		// });




	// 	// browser.addNodeActionToTreePopupMenu("Resolve recursively", new NodeAction() {
	// 	// 	@Override
	// 	// 	public void actionPerformed(TreeNode treeNode) {
	// 	// 		final Child child = treeNode.getChild();
	// 	// 		//server.invokeLater(new Runnable() {
	// 		// 		@Override
	// 		// 		public void run() {
	// 		// 			resolveRecursively(child);
	// 		// 		}
	// 		// 	});
	// 	// }
	// 	// });


		// // addNodeActionToTreePopupMenu("Store in file", new NodeAction() {
		// //     @Override
		// //     public void actionPerformed(final TreeNode treeNode) {
		// //         // final Node node = treeNode.getNode();
		// //         // server.invokeLater(new Runnable() {
		// //         //     @Override
		// //         //     public void run() {
		// //         //         try {
		// //         //             log.info("storing");
		// //         //             //File file = new File();
		// //         //             StoreStream stream = new StoreStream(file, server.getManager());
		// //         //             stream.store(node);
		// //         //         } catch (FileNotFoundException e) {
		// //         //             e.printStackTrace();
		// //         //         }
		// //         //     }
		// //         // });
		// //     }
		// // });


	// 	// arguments.forEach("resolve", new UnaryFunctor<Boolean, String>() {
	// 	// 	@Override
	// 	// 	public Boolean call(final String s) {
	// 	// 		server.getManager().resolvePath(s, new StateFunctor() {
	// 	// 			@Override
	// 	// 			public void call(Exception e) {
	// 	// 				if (e != null) {
	// 	// 					log.error("failed to resolve: {}", s);
	// 	// 					return;
	// 	// 				}
	// 	// 				log.info("succeeded to resolve: {}", s);
	// 	// 			}
	// 	// 		});
	// 	// 		return true;
	// 	// 	}
	// 	// });


	// 	// arguments.forEach("console", new UnaryFunctor<Boolean, String>() {
	// 	// 	@Override
	// 	// 	public Boolean call(String s) {
	// 	// 		showConsoleFrame().setCommandLine(s);
	// 	// 		return true;
	// 	// 	}
	// 	// });
	// }


	// /**
	//  * Creates panel with start, step, stop buttons.
	//  */
	// @Override
	// protected JPanel createLeftTopPanel() {
	// 	assert isActive();
	// 	Dimension buttonDimension = new Dimension(45, 45);

	// 	JPanel panel = new JPanel();

	// 	stop = new JButton(ImageProvider.loadImage(ImageProvider.SIM_STOP));
	// 	stop.addActionListener(new ActionListener() {

	// 		public void actionPerformed(ActionEvent e) {
	// 			setSimulationRunning(false);
	// 		}

	// 	});

	// 	stop.setPreferredSize(buttonDimension);
	// 	stop.setToolTipText("Simulation Stop");
	// 	stop.setEnabled(false);

	// 	step = new JButton(ImageProvider.loadImage(ImageProvider.SIM_STEP));
	// 	/*
	// 	step.addActionListener(new ActionListener() {

	// 		public void actionPerformed(ActionEvent e) {
	// 			connection.send(new CallQuery().setMethod("step").setPath("/simulator"));
	// 		}

	// 	});
	// 	*/

	// 	step.setPreferredSize(buttonDimension);
	// 	step.setToolTipText("Simulation Step");

	// 	start = new JButton(ImageProvider.loadImage(ImageProvider.SIM_START));
	// 	start.addActionListener(new ActionListener() {

	// 		public void actionPerformed(ActionEvent e) {
	// 			setSimulationRunning(true);
	// 		}

	// 	});

	// 	start.setPreferredSize(buttonDimension);
	// 	start.setToolTipText("Start Simulation");

	// 	JPanel buttonPanel = new JPanel();
	// 	buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.LINE_AXIS));
	// 	buttonPanel.add(Box.createHorizontalStrut(5));
	// 	buttonPanel.add(stop);
	// 	buttonPanel.add(Box.createHorizontalStrut(10));
	// 	buttonPanel.add(step);
	// 	buttonPanel.add(Box.createHorizontalStrut(10));
	// 	buttonPanel.add(start);
	// 	buttonPanel.add(Box.createHorizontalStrut(5));

	// 	buttonPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory
	// 			.createRaisedBevelBorder(), "Simulation Control",
	// 			TitledBorder.CENTER, TitledBorder.DEFAULT_POSITION
	// 			));

	// 	panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
	// 	panel.add(Box.createHorizontalGlue());
	// 	panel.add(buttonPanel);
	// 	panel.add(Box.createHorizontalGlue());
	// 	return panel;
	// }

	/**
	 * Sets frame properties.
	 */
	private void setFrameProperties() {
		assert isActive();
		getSwing().setMinimumSize(getSwing().getPreferredSize());
		getSwing().setSize(getSwing().getPreferredSize());
		getSwing().setMaximumSize(screenDimension);
		getSwing().setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

		getSwing().setIconImage(ImageProvider.loadImage(ImageProvider.LOGO)
				.getImage());


		getSwing().addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				assert isActive();
				/*
				if (connection != null) {
					connection.close();
				}
				*/
				onWindowClosing();
				getSwing().dispose();
			}
		});
	}

	// public ConsoleFrame showConsoleFrame() {
	// 	assert isActive();
	// 	/*
	// 	ConsoleFrame consoleFrame = new ConsoleFrame(connection);
	// 	consoleFrame.show(MainFrame.this);
	// 	return consoleFrame;
	// 	*/
	// 	return null;
	// }

	/**
	 * Closes connection with manager.
	 */
	private void disconnect() {
		assert isActive();
		browser.clear();
		onWindowClosing();
		// statusBar.setText("You are disconnected");
	}

	/**
	 * Method used while window is closing.
	 */
	private void onWindowClosing() {
		assert isActive();

	}

	public void setRunningButtons(boolean running) {
		assert isActive();
		step.setEnabled(!running);
		stop.setEnabled(running);
		start.setEnabled(!running);
	}

}

