package com.framsticks.core;

import javax.annotation.Nonnull;

import com.framsticks.params.Access;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.EventListener;
import com.framsticks.params.FramsClass;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.Registry;
import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.ExceptionResultHandler;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableDispatcher;

public interface Tree extends Dispatcher<Tree>, Joinable, ExceptionResultHandler {

	public @Nonnull Node getAssignedRoot();
	public void assignRootParam(CompositeParam param);
	public void assignRootObject(Object object);

	public @Nonnull Access prepareAccess(CompositeParam param);
	public void takeAllFrom(Registry source);

	public FramsClass getInfoFromCache(String id);

	public void putInfoIntoCache(FramsClass framclass);

	// /**
	//  *
	//  * Functions accepts ValueParam, because it is also possible to get number of List elements.
	//  *
	//  */
	// public void get(Path path, ValueParam param, Future<Object> future);

	public void get(Path path, Future<Path> future);

	public void call(Path path, ProcedureParam param, Object[] arguments, Future<Object> future);

	/**
	 *
	 * Functions accepts PrimitiveParam<?>, because it is not possible to set number of List elements.
	 *
	 */
	public void set(Path path, PrimitiveParam<?> param, Object value, Future<Integer> future);

	public void info(Path path, Future<FramsClass> future);

	public void setExceptionHandler(ExceptionResultHandler handler);

	public ExceptionResultHandler getExceptionHandler();

	public void setDispatcher(JoinableDispatcher<Tree> dispatcher);

	public JoinableDispatcher<Tree> getDispatcher();

	public <A> void addListener(Path path, EventParam param, EventListener<A> listener, Class<A> argumentType, Future<Void> future);

	public void removeListener(Path path, EventParam param, EventListener<?> listener, Future<Void> future);

	public Registry getRegistry();

	public void putSideNote(Object object, Object key, Object value);

	public boolean removeSideNote(Object object, Object key);

	public <T> T getSideNote(Object object, Object key, Class<T> valueType);

}
