package com.framsticks.core;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.parsers.XmlLoader;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableCollection;
import com.framsticks.util.dispatching.Monitor;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import java.io.InputStream;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
public class Framsticks extends JoinableCollection<Joinable> {
	private static final Logger log = LogManager.getLogger(Framsticks.class);

	public Framsticks() {

	}

	public static Framsticks loadConfiguration(InputStream stream) {
		return new XmlLoader().load(Framsticks.class, stream);
	}

	public static void main(final String[] args) {

		String config = "/configs/framsticks.xml";
		if (args.length != 0) {
			config = args[0];
		}

		new Monitor(loadConfiguration(Framsticks.class.getResourceAsStream(config))).use().waitFor().drop().join();

		log.debug("exiting main");
	}

	@Override
	public String toString() {
		return "framsticks";
	}

}
