package com.framsticks.core;

import java.util.Arrays;

import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import com.framsticks.core.ListChange.Action;
import com.framsticks.params.FramsClass;
import com.framsticks.params.ListSink;
import com.framsticks.params.ListSource;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.test.TestConfiguration;

import static org.fest.assertions.Assertions.*;

@Test
public class ListChangeTest extends TestConfiguration {

	FramsClass framsClass;
	ReflectionAccess access;
	ListChange listChange;

	@BeforeMethod
	public void clearListChange() {
		listChange = new ListChange();
	}

	// @Test
	// public void testEnumBehaviour() {
	// 	for (Action a : Action.class.getEnumConstants()) {
	// 		// assertThat(Integer.class.cast(a)).isEqualTo(a.ordinal());
	// 		assertThat(Action.class.cast(a.ordinal())).isEqualTo(a);
	// 	}

	// }

	@Test
	public void testFramsClass() {
		framsClass = FramsClass.build().forClass(ListChange.class);
		assertThat(framsClass.getParamCount()).isEqualTo(3);
	}

	@Test(dependsOnMethods = "testFramsClass")
	public void createReflectionAccess() {
		access = new ReflectionAccess(ListChange.class, framsClass);
	}

	@Test(dependsOnMethods = "createReflectionAccess")
	public void manualAccess() {
		access.select(listChange);

		access.set("type", 2);
		assertThat(listChange.action).isEqualTo(Action.Modify);

		listChange.action = Action.Remove;
		assertThat(access.get("type", Integer.class)).isEqualTo(1);
	}

	@Test(dependsOnMethods = "createReflectionAccess")
	public void load() throws Exception {
		access.select(listChange).load(ListSource.createFrom("type:2", "pos:0", "id:test"));

		assertThat(listChange.action).isEqualTo(Action.Modify);
		assertThat(listChange.position).isEqualTo(0);
		assertThat(listChange.identifier).isEqualTo("test");

		ListSink sink = new ListSink();
		access.select(listChange).save(sink);
		assertThat(sink.getOut()).isEqualTo(Arrays.asList("ListChange:", "type:2", "pos:0", "id:test", ""));
	}

}
