package com.framsticks.util.dispatching;

import com.framsticks.util.FramsticksException;

public class DispatchingExceptionHandler implements ExceptionResultHandler {

	protected final Dispatcher<?> dispatcher;
	protected final ExceptionResultHandler handler;

	/**
	 * @param dispatcher
	 * @param handler
	 */
	public DispatchingExceptionHandler(Dispatcher<?> dispatcher, ExceptionResultHandler handler) {
		this.dispatcher = dispatcher;
		this.handler = handler;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void handle(final FramsticksException exception) {
		dispatcher.dispatch(new RunAt(ThrowExceptionHandler.getInstance()) {
			@Override
			protected void runAt() {
				handler.handle(exception);
			}
		});
	}

}
