package com.framsticks.test;

import com.framsticks.core.ListChange;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation
public class TestChild {

	protected String name = "child";

	protected String uid;
	protected final TestClass parent;
	/**
	 *
	 */
	public TestChild(TestClass parent) {
		this.parent = parent;
		this.uid = "c" + (parent.counter++);
	}

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getName() {
		return name;
	}

	/**00:10:00
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setName(String name) {
		this.name = name;
		parent.fireChildrenChange(this, ListChange.Action.Modify);
	}

	/**
	 * @return the uid
	 */
	@ParamAnnotation
	public String getUid() {
		return uid;
	}

}
