package com.framsticks.parsers;

import com.framsticks.params.*;
import com.framsticks.params.SinkInterface;

/**
 * @author Piotr Sniegowski
 */
public class Savers {
	public static <S extends SinkInterface> S saveFramsClass(S sink, FramsClass framsClass) {

		Access framsClassAccess = new ReflectionAccess(FramsClass.class);
		Access paramAccess = new ReflectionAccess(Param.class);
		framsClassAccess.select(framsClass);
		framsClassAccess.save(sink);
		for (Param p : framsClass.getParamEntries()) {
			paramAccess.select(p);
			paramAccess.save(sink);
		}
		return sink;
	}

}
