package com.framsticks.parsers;

import com.framsticks.model.Model;
import com.framsticks.model.f0.Schema;
import com.framsticks.params.*;
import com.framsticks.util.Misc;
import com.framsticks.util.lang.Containers;
import static com.framsticks.util.lang.Containers.filterInstanceof;
import static com.framsticks.params.ParamFlags.*;

/**
 * Author: Piotr Śniegowski
 */
public class F0Writer {

	protected final Schema schema;
	protected final SinkInterface sink;
	protected final Model model;
	protected boolean omitDefaults = true;

	public F0Writer(Schema schema, Model model, SinkInterface sink) {
		this.schema = schema;
		this.model = model;
		this.sink = sink;
	}

	public F0Writer setOmitDefaults(boolean omitDefaults) {
		this.omitDefaults = omitDefaults;
		return this;
	}

	protected void write(Access access) {
		if (access instanceof ListAccess) {
			// TODO
			for (ValueParam p : Containers.filterInstanceof(access.getParams(), ValueParam.class)) {
				write(schema.getRegistry().prepareAccess((CompositeParam) p).select(access.get(p, Object.class)));
			}
			return;
		}
		StringBuilder line = new StringBuilder();
		line.append(access.getId()).append(":");
		boolean placeComma = false;
		boolean contiguous = true;

		for (ValueParam param : filterInstanceof(access.getParams(), ValueParam.class)) {
			if (param instanceof CompositeParam) {
				Access a = schema.getRegistry().prepareAccess((CompositeParam) param);
				a.select(access.get((ValueParam) param, Object.class));
				write(a);
				continue;
			}
			Object value = access.get(param, Object.class);
			if (omitDefaults && (param instanceof PrimitiveParam) && Misc.equals(value, ((PrimitiveParam<?>) param).getDef(Object.class))) {
				contiguous = false;
				continue;
			}
			if (value == null) {
				contiguous = false;
				continue;
			}

			if (placeComma) {
				line.append(",");
			} else {
				placeComma = true;
			}

			if ((!contiguous) || ((param.getFlags() & CANOMITNAME) == 0)) {
				line.append(param.getId()).append("=");
				contiguous = true;
			}
			String printed = value.toString().replace("\"", "\\\"");
			if (printed.contains(",")) {
				line.append("\"").append(printed).append("\"");
			} else {
				line.append(value);
			}
		}
		sink.print(line).breakLine();
	}

	public void write() {
		Access access = schema.getRegistry().createAccess("m");
		access.select(model);
		write(access);
	}


}
