package com.framsticks.params.types;

import com.framsticks.params.Access;
import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ReassignResult;
import com.framsticks.params.UniqueListAccess;
import com.framsticks.util.lang.Casting;
import com.framsticks.util.lang.Numbers;

import java.util.Map;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class UniqueListParam extends ListParam {

	final String uidName;

	public UniqueListParam(ParamBuilder builder) {
		super(builder);
		this.uidName = builder.getUid();
	}

	@Override
	public String computeAccessId() {
		return "l " + containedTypeName + " " + uidName;
	}


	@Override
	public Class<?> getStorageType() {
		return Map.class;
	}

	@Override
	public Access prepareAccess(Access access) {
		return new UniqueListAccess(access, uidName);
	}

	@Override
	public ReassignResult<? extends Map<?,?>> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue instanceof Map) {
			return new ReassignResult<Map<?,?>>((Map<?,?>) newValue);
		}
		Integer size = Numbers.cast(newValue, Integer.class);
		if (size != null) {
			//return oldValue;
			/*
			the integer value should be ignored, because this may cause, that object is created before
			information about it's elements is available, which would break resolution flow
			*/
			return new ReassignResult<Map<?,?>>(Casting.tryCast(Map.class, oldValue));
			// return ReassignResult.create(new TreeMap<Object, Object>());
		}

		throw new CastFailure();
	}

	@Override
	public String getFramsTypeName() {
		return "l " + containedTypeName + " " + uidName;
	}


}
