package com.framsticks.params;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public abstract class CompositeParam extends ValueParam {

	protected final String containedTypeName;

	public CompositeParam(ParamBuilder builder) {
		super(builder);
		this.containedTypeName = builder.getContainedTypeName();
	}

	public boolean isMatchingContainedName(String name) {
		assert name != null;
		if (containedTypeName == null) {
			return true;
		}
		return name.equals(containedTypeName);
	}

	public String getContainedTypeName() {
		return containedTypeName;
	}

	public abstract Access prepareAccess(Access access);

	public abstract String computeAccessId();

	public <T> T getDef(Class<T> type) throws ClassCastException {
		return null;
	}

	@Override
	public String toString() {
		return getId() + ":" + this.getClass().getSimpleName() + "(" + containedTypeName + ")";
	}

}
