package com.framsticks.hosting;

import java.util.Map;
import java.util.TreeMap;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.communication.Response;
import com.framsticks.communication.ServerSideResponseFuture;
import com.framsticks.core.Path;
import com.framsticks.core.Tree;
import com.framsticks.params.EventListener;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.EventParam;
import com.framsticks.util.dispatching.FutureHandler;
import com.framsticks.util.dispatching.ThrowExceptionHandler;

@FramsClassAnnotation
public class Cli {
	private static final Logger log =
		LogManager.getLogger(Cli.class);


	protected int eventCounter = 0;
	protected final Tree tree;
	protected final ClientAtServer client;

	@ParamAnnotation
	public final Map<String, CliEvent> events = new TreeMap<>();

	/**
	 * @param tree
	 */
	public Cli(ClientAtServer client) {
		this.client = client;
		this.tree = client.getTree();
	}

	public void addListener(Path path, EventParam param, String pathPrefix, ServerSideResponseFuture responseFuture) {
		log.debug("adding listener for {}: {}", path, param);

		final CliEvent event = new CliEvent();
		event.cli = this;
		event.id = "e" + (eventCounter++);
		event.path = path;
		event.param = param;
		event.name = pathPrefix + Path.appendString(path.getTextual(), param.getId());
		event.pathToEvent = "/cli/events/" + event.id;

		event.listener = new EventListener<Object>() {

			@Override
			public void action(Object argument) {
				log.debug("registered event {} happened with {}", event, argument);

				client.connection.sendFile(
						"event " + event.pathToEvent + " " + event.name,
						ClientAtServer.printToFile("", tree.getRegistry().createAccess(argument.getClass()).select(argument))
					);
			}
		};

		// SyncedFuture handler = new SyncedFuture<Void>(ThrowExceptionHandler.getInstance());
		path.getTree().addListener(path, param, event.listener, Object.class, FutureHandler.doNothing(Void.class, ThrowExceptionHandler.getInstance()));

		events.put(event.id, event);
		responseFuture.pass(new Response(true, event.pathToEvent, null));
		// handler
	}

	@Override
	public String toString() {
		return "CLI for " + tree;
	}

}
