package com.framsticks.gui.table;

import com.framsticks.params.PrimitiveParam;
import com.framsticks.util.UnsupportedOperationException;

public class PrimitiveColumn extends Column {

	public PrimitiveColumn(PrimitiveParam<?> param, TableModel tableModel) {
		super(param, tableModel);
	}

	@Override
	public PrimitiveParam<?> getParam() {
		return (PrimitiveParam<?>) param;
	}

	@Override
	public Class<?> getColumnClass() {
		return getParam().getStorageType();
	}

	@Override
	public Object getValueAt(int rowIndex) {
		Object object = tableModel.getAccess().get(rowIndex, Object.class);
		if (object == null) {
			return null;
		}
		return tableModel.getElementAccess().select(object).get(getParam(), Object.class);
	}

	@Override
	public int setValueAt(int rowIndex, Object value) {
		throw new UnsupportedOperationException().msg("setting value in table");
	}

	@Override
	public boolean isEditable() {
		return false;
	}

}
