package com.framsticks.gui.controls;

import java.awt.BorderLayout;

import javax.swing.JComponent;
import javax.swing.JPanel;

import com.framsticks.params.ParamFlags;
import com.framsticks.params.Param;
import com.framsticks.util.FramsticksException;
import com.framsticks.util.dispatching.ExceptionResultHandler;

/**
 * Interface that each class that want to be component must implement.
 */
@SuppressWarnings("serial")
public abstract class Control extends JPanel implements ExceptionResultHandler {

	public static final int LINE_HEIGHT = 36;

	// private static final Logger log = LogManager.getLogger(Control.class.getName());

	protected final Param param;
	protected ControlOwner owner;

	protected abstract void updateEnabled(boolean enabled);

	private boolean userEnabled = true;

	public Control(Param param) {
		this.param = param;
		setName(param.getId());
	}

	public Param getParam() {
		return param;
	}

	public void setOwner(ControlOwner owner) {
		this.owner = owner;
	}

	/**
	 * @return the userEnabled
	 */
	public final boolean isUserEnabled() {
		return userEnabled;
	}

	/**
	 * @param userEnabled the userEnabled to set
	 */
	public final void setUserEnabled(boolean userEnabled) {
		this.userEnabled = userEnabled;
		updateEnabled(!isReadonly());
	}

	public final boolean isReadonly() {
		return !userEnabled || param.hasFlag(ParamFlags.READONLY);
	}

	protected void addAsOnlyChild(JComponent component) {
		this.setLayout(new BorderLayout());
		this.add(component, BorderLayout.CENTER);
	}

	@Override
	public String toString() {
		return param.toString();
	}

	@Override
	public void handle(FramsticksException exception) {
		owner.handle(exception);
	}
}
