package com.framsticks.gui;


import java.awt.BorderLayout;
import java.awt.Dimension;
// import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.JTextField;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.gui.controls.Control;
import com.framsticks.util.FramsticksException;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.ExceptionResultHandler;
import com.framsticks.util.dispatching.RunAt;

public class StatusBar implements ExceptionResultHandler, Dispatcher<StatusBar> {
	private static final Logger log = LogManager.getLogger(StatusBar.class);

	protected JTextField statusBar;
	protected JPanel swing;
	protected ExceptionResultHandler exceptionHandler;

	/**
	 *
	 */
	public StatusBar() {
	}

	@Override
	public void handle(final FramsticksException exception) {
		dispatch(new RunAt<StatusBar>(this) {

			@Override
			protected void runAt() {
				log.error("error: {}", exception.getMessage());
				statusBar.setText(exception.getShortMessage(new StringBuilder()).toString());
				if (exceptionHandler != null) {
					exceptionHandler.handle(exception);
				}
			}
		});
	}

	public void initializeGui() {
		statusBar = new JTextField();
		statusBar.setEditable(false);

		swing = new JPanel();
		swing.setMaximumSize(new Dimension(Integer.MAX_VALUE, Control.LINE_HEIGHT));

		swing.setLayout(new BorderLayout());
		swing.add(statusBar, BorderLayout.CENTER);
		// swing.add(statusBar);
	}

	@Override
	public boolean isActive() {
		return SwingDispatcher.getInstance().isActive();
	}

	@Override
	public void dispatch(RunAt<? extends StatusBar> runnable) {
		SwingDispatcher.getInstance().dispatch(runnable);
	}

	/**
	 * @return the swing
	 */
	public JPanel getSwing() {
		return swing;
	}

	/**
	 * @return the exceptionHandler
	 */
	public ExceptionResultHandler getExceptionHandler() {
		return exceptionHandler;
	}

	/**
	 * @param exceptionHandler the exceptionHandler to set
	 */
	public void setExceptionHandler(ExceptionResultHandler exceptionHandler) {
		this.exceptionHandler = exceptionHandler;
	}

}
