package com.framsticks.gui;

import com.framsticks.core.Path;
import com.framsticks.params.Access;

import javax.swing.*;

import java.awt.*;
import java.util.List;

/**
 * Author: Piotr Śniegowski
 */
@SuppressWarnings("serial")
public class MultiPanel extends TreePanel {

	protected final List<TreePanel> panels;
	protected final JTabbedPane tabbedPane;


	public MultiPanel(TreePanel.Parameters parameters, List<TreePanel> panels) {
		super(parameters);
		this.panels = panels;
		tabbedPane = new JTabbedPane();

		for (TreePanel p : panels) {
			assert p.getClassName().equals(getClassName());
			assert p.getTreeAtFrame() == getTreeAtFrame();
			tabbedPane.add(p.getTitle(), p);
		}

		this.setLayout(new BorderLayout());
		this.add(tabbedPane, BorderLayout.CENTER);

	}

	@Override
	public void pullValuesFromLocalToUser(Access access) {
		for (TreePanel p : panels) {
			p.pullValuesFromLocalToUser(access);
		}
	}

	@Override
	public String getTitle() {
		return className;
	}

	@Override
	public void setCurrentPath(Path currentPath) {
		super.setCurrentPath(currentPath);
		for (TreePanel p : panels) {
			p.setCurrentPath(currentPath);
		}
	}
}
