/**
 *
 */
package com.framsticks.gui;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import javax.swing.*;

import java.util.HashMap;
import java.util.Map;

/**
 * Class provides icons images.
 */
public class ImageProvider {

	private final static Logger log = LogManager.getLogger(ImageProvider.class.getName());


	/**
	 * HashMap stores icons. Key is icon path, Value is icon.
	 */
	private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();

	public static final String IMAGE = "image.png";
	public static final String LOGO = "logo.png";

	public static final String FOLDER_OPEN = "folder_open.png";
	public static final String FOLDER_CLOSED = "folder_close.png";
	public static final String NODE = "node.png";

	public static final String SERVER = "server.png";

	public static final String CLI = "cli.png";
	public static final String EVENT = "event.png";
	public static final String SIMULATOR = "simulator.png";

	public static final String WORLD = "World.png";
	public static final String GENEPOOLS = "genepools.png";
	public static final String GENEPOOLS_GROUP = "genepoolsgroup.png";
	public static final String POPULATIONS = "populations.png";
	public static final String POPULATION_GROUP = "populationgroup.png";
	public static final String STATISTIC = "statistic.png";
	public static final String EXPERIMENT = "experiment.png";

	public static final String CREATURES_GROUP = "CreaturesGroup.png";
	public static final String CREATURE = "Creature.png";

	public static final String GENOTYPES_GROUP = "GenotypeGroup.png";
	public static final String GENOTYPES = "Genotype.png";

	public static final String JOINT_GROUP = "l_Joint.png";
	public static final String JOINT = "Joint.png";
	public static final String MECH_JOINT_GROUP = "l_MechJoint.png";
	public static final String MECH_JOINT = "MechJoint.png";
	public static final String PART_GROUP = "l_Part.png";
	public static final String PART = "Part.png";
	public static final String MECH_PART_GROUP = "l_MechPart.png";
	public static final String MECH_PART = "MechPart.png";
	public static final String NEURON_GROUP = "l_Neuro.png";
	public static final String NEURON = "Neuro.png";
	public static final String NEURON_DEF_GROUP = "l_NeuroDef.png";
	public static final String NEURON_DEF = "NeuroDef.png";

	public static final String FAVORITES = "stats.png";
	public static final String FAVORITE_FIELDS = "FavouriteFields.png";

	public static final String SIM_START = "sim_start.png";
	public static final String SIM_STEP = "sim_step.png";
	public static final String SIM_STOP = "sim_stop.png";

	/**
	 * Loads image icon with the given getName(path).
	 *
	 * @param imageName Name of the image(including extension) which will be loaded.
	 * @return Loaded image.
	 */
	public static ImageIcon loadImage(final String imageName) {
		if (icons.containsKey(imageName)) {
			return icons.get(imageName);
		}
		String resourceName = "/shared/res/network/" + imageName;
		try {
			ImageIcon icon = new ImageIcon(ImageProvider.class.getResource(resourceName));
			icons.put(imageName, icon);
			return icon;
		} catch (Exception ignored) {
			log.error("failed to read icon: {}", resourceName);
		}
		return null;
	}
}
