package com.framsticks.gui;

import java.util.concurrent.atomic.AtomicInteger;

import javax.swing.*;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import com.framsticks.gui.tree.AbstractNode;

/**
 * Author: Piotr Śniegowski
 */
@SuppressWarnings("serial")
public abstract class AbstractPanel extends JPanel {

	private static final Logger log = LogManager.getLogger(AbstractPanel.class);

	protected final Frame frame;

	protected final String uniqueName;
	protected final static AtomicInteger counter = new AtomicInteger();

	/**
	 * @param frame
	 */
	public AbstractPanel(Frame frame) {
		this.frame = frame;
		this.uniqueName = "panel_" + counter.getAndIncrement();

		frame.cardPanel.add(this, uniqueName);
		frame.cardPanelLayout.addLayoutComponent(this, uniqueName);
		log.debug("created panel {}", uniqueName);
	}

	public final Frame getFrame() {
		return frame;
	}

	public abstract String getTitle();

	public final String getUniqueName() {
		return uniqueName;
	}

	public abstract void fillPanelWith(AbstractNode node);

	@Override
	public String toString() {
		return uniqueName;
	}
}
