package com.framsticks.core;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.Misc;
import com.framsticks.util.lang.Strings;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation(order = {"type", "pos", "id"})
public class ListChange {


	/**
	 * @param action
	 */
	public ListChange(Action action, Integer position, String identifier) {
		this.action = action;
		this.position = position;
		this.identifier = identifier;
	}

	/**
	 *
	 */
	public ListChange() {
	}

	public Action getAction() {
		return action;
	}

	public Integer getPosition() {
		return position;
	}

	public String getIdentifier() {
		return identifier;
	}

	public static enum Action {
		Add,
		Remove,
		Modify
		// Add(0),
		// Remove(1),
		// Modify(2);

		// public final int value;

		// /**
		//  * @param value
		//  */
		// Action(int value) {
		//	this.value = value;
		// }

	}

	public Action action = Action.Add;
	@ParamAnnotation(id = "pos", def = "-1")
	public Integer position;
	@ParamAnnotation(id = "id")
	public String identifier;

	@ParamAnnotation
	public Integer getType() { return action.ordinal(); }
	@ParamAnnotation
	public void setType(Integer type) { action = Action.values()[type]; }

	public String getBestIdentifier() {
		if (Strings.notEmpty(identifier)) {
			return identifier;
		}
		return position.toString();
	}

	@Override
	public String toString() {
		return action + " " + identifier + " " + position;
	}

	@Override
	public boolean equals(Object object) {
		if (object instanceof ListChange) {
			ListChange r = (ListChange) object;
			return Misc.equals(action, r.action) && Misc.equals(position, r.position) && Misc.equals(identifier, r.identifier);
		}
		return false;
	}

}
