function dumpCreatures(direct)
{
  var pop=Populations[0];
  var f;
  if (direct!=0)
  	  f = File.createDirect("dump.txt", "Coordinates, velocities and stress (linear and rotational).");
  else
  	  f = File.create("dump.txt", "Coordinates, velocities and stress (linear and rotational).");
  f.writeComment("parts are points, joints are sticks.");
  f.writeComment("format for parts: x y z vx vy vz");
  f.writeComment("format for joints: part1index(0-based)  part2index(0-based)  stresslinear  stressrotational");
  for (var cr in pop)
  {
    f.writeString("\n# creature_number  number_of_parts  number_of_joints\n");
    f.writeString(""+cr.index+" "+cr.numparts+" "+cr.numjoints+"\n");
    for (var j = 0;j < cr.numparts;j++)
    {
      var part = cr.getMechPart(j);
      f.writeString(""+part.x+" "+part.y+" "+part.z+" "+part.vx+" "+part.vy+" "+part.vz+"\n");
    }
    var model=cr.model;
    for (var j = 0;j < cr.numjoints;j++)
    {
      var joint = cr.getMechJoint(j);
      var modeljoint=model.getJoint(j);
      f.writeString(""+modeljoint.p1+" "+modeljoint.p2+" "+joint.stress+" "+joint.rotstress+"\n");
    }
  }
  f.close();
}
