package com.framsticks.net.client3D;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

/**
 * Atrapa polaczenia z serwerem. Zamiast laczyc sie przez siec dane pobiera z plikow tekstowych.
 * 
 * @author vorg
 */
public class CommunicationMock extends Communication {
	private String message;
	
	public void connect(String ip, int port) throws IOException {		
		connected = true;
	}
	
	public void disconnect() throws IOException {
		connected = false;
	}				

  	public ArrayList<String> readMessage()
  	throws IOException, InterruptedException, CommunicationErrorException {		
  		ArrayList<String> buffer = new ArrayList<String>();
  		if (message.indexOf("name,genotype,parts,joints") > -1) {
  			buffer = readFile("res/mock/creature_Oafuz_info.txt");
  		}
  		else if (message.indexOf("/joints p1,p2") > -1) {
  			buffer = readFile("res/mock/creature_Oafuz_joints.txt");
  		} 
  		else if (message.indexOf("/parts x,y,z") > -1) {
  			buffer = readFile("res/mock/creature_Oafuz_parts.txt");
  		} 
  		else if (message.indexOf("/neurodefs") > -1) {
  			buffer = readFile("res/mock/creature_Oafuz_neurons.txt");
  		}
  		else if (message.indexOf("/groups/+/creatures/+/") > -1) {
  			buffer = readFile("res/mock/creatures.txt");
  		}
  		else if (message.indexOf("/world") > -1) {
  			buffer = readFile("res/mock/world.txt");
  		}
  		return buffer;
  	}										  																																			

	public void sendMessage(String message) {		
		Log.getInstance().log(">>>", message);
		this.message = message;
	}			

	public ArrayList<String> getLog() {
		return new ArrayList<String>();
	}
	
	private ArrayList<String> readFile(String path) {
		ArrayList<String> result = new ArrayList<String>();
		try {
			BufferedReader reader = new BufferedReader(new FileReader(path));
			String line = null;
			while((line = reader.readLine()) != null) {
				result.add(line);
			}
		} 
		catch (Exception e) {
			Log.getInstance().log("err", e.toString());
		}
		
		return result;
	}

}

