//name stone
//vert
	
varying vec2 texCoord;
varying vec3 normalVec; 

void main(void)
{
	gl_Position = ftransform();
	texCoord = gl_MultiTexCoord0.xy * 0.4;
	normalVec = normalize(gl_NormalMatrix * gl_Normal);
}
	
//frag

varying vec2 texCoord;
uniform sampler2D diffuseMap;
varying vec3 normalVec;

void main (void)
{
	vec4 base = texture2D(diffuseMap, texCoord);
	
	float c = dot(normalVec, vec3(0,0,-1));
	c = abs(c);
	gl_FragColor = base * (1.0-c);
}