/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import javax.media.opengl.GLException;

public class GLContextLock {
    private Object lock = new Object();
    private Thread owner;
    private boolean failFastMode = true;
    private volatile int waiters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws GLException {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (this.owner == null) {
                this.owner = thread;
            } else if (this.owner != thread) {
                while (this.owner != null) {
                    if (this.failFastMode) {
                        throw new GLException("Attempt to make context current on thread " + thread + " which is already current on thread " + this.owner);
                    }
                    try {
                        ++this.waiters;
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new GLException(interruptedException);
                    }
                    finally {
                        --this.waiters;
                    }
                }
                this.owner = thread;
            } else {
                throw new GLException("Attempt to make the same context current twice on thread " + thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws GLException {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (this.owner != thread) {
                if (this.owner != null) {
                    throw new GLException("Attempt by thread " + thread + " to release context owned by thread " + this.owner);
                }
                throw new GLException("Attempt by thread " + thread + " to release unowned context");
            }
            this.owner = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeld() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            return this.owner == thread;
        }
    }

    public void setFailFastMode(boolean bl) {
        this.failFastMode = bl;
    }

    public boolean getFailFastMode() {
        return this.failFastMode;
    }

    public boolean hasWaiters() {
        return this.waiters != 0;
    }
}

