/* 
 * (C) Poznan University of Technology
 * File name: Options.java.
 * Created on 2003-12-03 12:05:59.
 */
package frams_client_3d;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;

import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/**
 * Left options panel class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Options extends JPanel {

	private boolean connected;
	private boolean started;
	private boolean stopped;
	private boolean log;
	private boolean tree;
	private boolean show;

	private DefaultTreeModel treeModel;
	
	private javax.swing.JLabel jLabel = null;
	private javax.swing.JTextField jTextField = null;
	private javax.swing.JLabel jLabel1 = null;
	private javax.swing.JTextField jTextField1 = null;
	private javax.swing.JButton jButton = null;	
	private javax.swing.JScrollPane jScrollPane = null;
	private javax.swing.JTree jTree = null;
	
	private javax.swing.JButton jButton1 = null;
	private javax.swing.JButton jButton2 = null;
	private javax.swing.JLabel jLabel2 = null;
	private javax.swing.JButton jButton3 = null;


	private javax.swing.JLabel jLabel3 = null;
	private javax.swing.JCheckBox jCheckBox = null;
	/**
	 * This is the default constructor
	 */
	public Options() {
		super();
		initialize();
		setConnected(false);
	}
	/**
	 * This method initializes this
	 * @return void
	 */
	private void initialize() {
		this.setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));
		this.add(getJScrollPane(), null);
		this.add(Box.createRigidArea(new Dimension(0,10)));
		this.add(getJLabel2(), null);
		this.add(Box.createRigidArea(new Dimension(0,2)));		
		this.add(getJButton1(), null);
		this.add(getJButton2(), null);
		this.add(Box.createRigidArea(new Dimension(0,10)));
		this.add(getJLabel3(), null);
		this.add(getJCheckBox(), null);
		this.add(Box.createRigidArea(new Dimension(0,15)));
		this.add(Box.createVerticalGlue());
		this.add(getJLabel(), null);		
		this.add(Box.createRigidArea(new Dimension(0,2)));
		this.add(getJTextField(), null);
		add(Box.createRigidArea(new Dimension(0,5)));
		this.add(getJLabel1(), null);
		add(Box.createRigidArea(new Dimension(0,2)));		
		this.add(getJTextField1(), null);
		add(Box.createRigidArea(new Dimension(0,5)));
		this.add(getJButton(), null);
		this.add(getJButton3(), null);		
		add(Box.createRigidArea(new Dimension(0,5)));
		
		Dimension size = this.getPreferredSize();
		this.setSize(size);
	}
	/**
	 * This method initializes jLabel
	 * @return javax.swing.JLabel
	 */
	private javax.swing.JLabel getJLabel() {
		if(jLabel == null) {
			jLabel = new javax.swing.JLabel();
			jLabel.setText("server IP");
			jLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jLabel;
	}
	/**
	 * This method initializes jTextField
	 * @return javax.swing.JTextField
	 */
	private javax.swing.JTextField getJTextField() {
		if(jTextField == null) {
			jTextField = new javax.swing.JTextField();
			jTextField.setText("127.0.0.1");
			jTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
			Dimension size = jTextField.getPreferredSize();
			size.width += 20;
			jTextField.setMaximumSize(size);
			jTextField.setAlignmentX(Component.CENTER_ALIGNMENT);			
		}
		return jTextField;
	}
	/**
	 * This method initializes jLabel1
	 * @return javax.swing.JLabel
	 */
	private javax.swing.JLabel getJLabel1() {
		if(jLabel1 == null) {
			jLabel1 = new javax.swing.JLabel();
			jLabel1.setText("server port");
			jLabel1.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jLabel1;
	}
	/**
	 * This method initializes jTextField1
	 * @return javax.swing.JTextField
	 */
	private javax.swing.JTextField getJTextField1() {
		if(jTextField1 == null) {
			jTextField1 = new javax.swing.JTextField();
			jTextField1.setText("9009");
			jTextField1.setHorizontalAlignment(javax.swing.JTextField.CENTER);
			Dimension size = jTextField1.getPreferredSize();
			size.width += 20;
			jTextField1.setMaximumSize(size);
			jTextField1.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jTextField1;
	}
	/**
	 * This method initializes jButton
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton() {
		if(jButton == null) {
			jButton = new javax.swing.JButton();
			jButton.setText("Disconnect");
			jButton.setAlignmentX(Component.CENTER_ALIGNMENT);
			jButton.setMaximumSize(jButton.getPreferredSize());
			jButton.setMinimumSize(jButton.getPreferredSize());
			jButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {					
					setConnected(!connected);
					firePropertyChange("connected", !connected, connected);										
				}
			});						
		}
		return jButton;
	}
	/**
	 * This method initializes jScrollPane
	 * @return javax.swing.JScrollPane
	 */
	private javax.swing.JScrollPane getJScrollPane() {
		if(jScrollPane == null) {
			jScrollPane = new javax.swing.JScrollPane();
			jScrollPane.setViewportView(getJTree());
		}
		return jScrollPane;
	}
	/**
	 * This method initializes jTree
	 * @return javax.swing.JTree
	 */
	private javax.swing.JTree getJTree() {
		if(jTree == null) {
			jTree = new javax.swing.JTree();			
			TreeSelectionModel model = jTree.getSelectionModel();
			model.setSelectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
			jTree.setRootVisible(false);
			jTree.setShowsRootHandles(true);
			jTree.setVisible(false);			
			jTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() { 
				public void valueChanged(javax.swing.event.TreeSelectionEvent e) {    
					firePropertyChange("tree", false, true);
				}
			});
			ToolTipManager.sharedInstance().registerComponent(jTree);
			jTree.setCellRenderer(new OptionsTreeRenderer());
		}
		return jTree;
	}	
	/**
	 * Set the tree model.
	 * @param treeModel
	 */
	public void setTree(DefaultTreeModel treeModel) {
		this.treeModel = treeModel;
		jTree.setModel(treeModel);
		jTree.setVisible(true);
		jCheckBox.setEnabled(true);				
	}	
	/**
	 * This method initializes jButton1
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton1() {
		if(jButton1 == null) {
			jButton1 = new javax.swing.JButton();			
			jButton1.setText("Start");
			jButton1.setAlignmentX(Component.CENTER_ALIGNMENT);
			jButton1.setPreferredSize(new java.awt.Dimension(80,20));
			jButton1.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {										
					setStarted(!started);
					setStopped(!started);
					firePropertyChange("started", !started, started);					
				}
			});	
		}
		return jButton1;
	}
	/**
	 * This method initializes jButton2
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton2() {
		if(jButton2 == null) {
			jButton2 = new javax.swing.JButton();
			jButton2.setText("Stop");
			jButton2.setAlignmentX(Component.CENTER_ALIGNMENT);
			jButton2.setPreferredSize(new java.awt.Dimension(80,20));
			jButton2.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {										
					setStopped(!stopped);
					setStarted(!stopped);
					firePropertyChange("stopped", !stopped, stopped);					
				}
			});	
		}
		return jButton2;
	}
	/**
	 * This method initializes jLabel2 
	 * @return javax.swing.JLabel
	 */
	private javax.swing.JLabel getJLabel2() {
		if(jLabel2 == null) {
			jLabel2 = new javax.swing.JLabel();			
			jLabel2.setText("simulation");
			jLabel2.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jLabel2;
	}
	/**
	 * This method initializes jButton3 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton3() {
		if(jButton3 == null) {
			jButton3 = new javax.swing.JButton();
			jButton3.setText("Log");
			jButton3.setAlignmentX(Component.CENTER_ALIGNMENT);			
			jButton3.setMaximumSize(jButton.getPreferredSize());
			jButton3.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {															
					firePropertyChange("logs", false, true);					
				}
			});				
		}
		return jButton3;
	}
	/**
	 * This method initializes jLabel3
	 * 
	 * @return javax.swing.JLabel
	 */
	private javax.swing.JLabel getJLabel3() {
		if(jLabel3 == null) {
			jLabel3 = new javax.swing.JLabel();
			jLabel3.setText("show selected");
			jLabel3.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jLabel3;
	}
	/**
	 * This method initializes jCheckBox
	 * 
	 * @return javax.swing.JCheckBox
	 */
	private javax.swing.JCheckBox getJCheckBox() {
		if(jCheckBox == null) {
			jCheckBox = new javax.swing.JCheckBox();
			jCheckBox.setAlignmentX(Component.CENTER_ALIGNMENT);			
			jCheckBox.setMaximumSize(jCheckBox.getPreferredSize());
			jCheckBox.setSelected(true);
			setShow(true);
			jCheckBox.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {															
					setShow(!show);
					firePropertyChange("show", !show, show);					
				}
			});	
		}
		return jCheckBox;
	}	
	/**
	 * Connected property getter
	 * @return true if connected
	 */
	public boolean isConnected() {
		return connected;
	}
	/**
	 * Started property getter
	 * @return true if simulation is started
	 */
	public boolean isStarted() {
		return started;
	}
	/**
	 * Stopped property getter
	 * @return true if simulation stopped
	 */
	public boolean isStopped() {
		return stopped;
	}	
	/**
	 * Connected property setter
	 * @param b
	 */
	public void setConnected(boolean b) {		
		connected = b;
		if (b) {
			jButton.setText("Disonnect");
		} else {
			jCheckBox.setEnabled(false);
			jButton.setText("Connect");
		}
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		jButton3.setEnabled(true);
	}
	/**
	 * Started property setter.
	 * @param b
	 */
	public void setStarted(boolean b) {
		started = b;
		jButton1.setEnabled(!b);
	}
	/**
	 * Stopped property setter.
	 * @param b
	 */
	public void setStopped(boolean b) {
		stopped = b;
		jButton2.setEnabled(!b);
	}
	/**
	 * Log property getter.
	 * @return true if logs are set 
	 */
	public boolean isLog() {
		return log;
	}
	/**
	 * Log setter.
	 * @param b
	 */
	public void setLog(boolean b) {
		log = b;
	}
	/**
	 * Show selected property getter.
	 * @return true if show selected is checked
	 */
	public boolean isShow() {
		return show;
	}
	/**
	 * Show selected setter.
	 * @param b
	 */
	public void setShow(boolean b) {
		show = b;
	}
	/**
	 * Server IP address getter
	 * @return String ip
	 */
	public String getIp() {
		return jTextField.getText();
	}
	/**
	 * Server port getter 
	 * @return int port
	 */
	public int getPort() {
		return Integer.parseInt(jTextField1.getText());
	}
	/**
	 * Tree property getter.
	 * @return true if tree element is selected
	 */
	public boolean isTree() {
		return tree;
	}
	/**
	 * Tree property setter.
	 * @param b
	 */
	public void setTree(boolean b) {
		tree = b;
	}
	/**
	 * Returns list of creatures selected form the tree.
	 * @return creatures list
	 */
	public ArrayList getSelection() {
		ArrayList list = new ArrayList();
		javax.swing.tree.TreePath[] paths = jTree.getSelectionPaths();
		for (int i = 0; i < jTree.getSelectionCount(); ++i) {
			DefaultMutableTreeNode node = (DefaultMutableTreeNode)
				paths[i].getLastPathComponent();
			if (null == node) {			
				continue;
			}			
			try {
				Creature creature = (Creature)node.getUserObject();
				list.add(creature);
			} catch (ClassCastException e) {}			
		}
		return list;
	}
	/**
	 * Returns list of all creatures in the tree.
	 * @return creatures list
	 */
	public ArrayList getAllCreatures() {
		ArrayList list = new ArrayList();
		DefaultMutableTreeNode rootNode, groupNode, node;
		rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
		
		for (int i = 0; i < rootNode.getChildCount(); ++i) {
			groupNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
			for (int j = 0; j < groupNode.getChildCount(); ++j) {
				node = (DefaultMutableTreeNode)groupNode.getChildAt(j);
				if (null == node) {
					continue;
				}			
				try {
					Creature creature = (Creature)node.getUserObject();
					list.add(creature);
				} catch (ClassCastException e) {}			
			}
		}
		return list;
	}
	/**
	 * Add a node to the tree.
	 * @param node the added tree node
	 * @param group the group of a node
	 * @param index the index of a node in the group
	 */
	public void addTreeNode(DefaultMutableTreeNode node, int group, int index) {
		DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
		DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)rootNode.getChildAt(group);	
		treeModel.insertNodeInto(node, groupNode, index);
		jTree.scrollPathToVisible(new TreePath(node.getPath()));
	}
	/**
	 * Add a node to the tree.
	 * @param node the added tree node
	 * @param index the index of a group in the tree
	 */
	public void addTreeNode(DefaultMutableTreeNode node, int index) {
		DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();	
		treeModel.insertNodeInto(node, rootNode, index);
		jTree.scrollPathToVisible(new TreePath(node.getPath()));
	}
	/**
	 * Remove a node from the tree.
	 * @param group the group of a node
	 * @param index the index of a node in the group
	 */
	public void removeTreeNode(int group, int index) {
		DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
		DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)rootNode.getChildAt(group);
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)groupNode.getChildAt(index);
		jTree.scrollPathToVisible(new TreePath(node.getPath()));
		treeModel.removeNodeFromParent(node);
	}
	/**
	 * Remove a node from the tree.
	 * @param index the index of a group in the tree
	 */
	public void removeTreeNode(int index) {
		DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(index);
		jTree.scrollPathToVisible(new TreePath(node.getPath()));
		treeModel.removeNodeFromParent(node);
	}		
	/**
	 * Class for managing creatures tree tooltips.
	 * @author MoMaT
	 */
	private class OptionsTreeRenderer extends DefaultTreeCellRenderer {

		public OptionsTreeRenderer() {
			//initialize icons
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel,
			boolean expanded, boolean leaf,	int row, boolean hasFocus) {

			super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row,
				hasFocus);
		
			if (leaf) {
				DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
				try {
						Creature creature = (Creature)node.getUserObject();
						setToolTipText(creature.getGenotype());
				} catch (ClassCastException e) {
					setToolTipText((String)node.getUserObject());
				}
			} 
			return this;
		}
	}
}
